/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.viewer;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerContext;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public abstract class AbstractViewInstance
implements ViewInstance {
    private static final String PROP_DEFAULT_INSTANCE = "defaultInstance";
    private static final String PROP_LAZY = "lazy";
    private static final String PROP_VISIBLE = "visible";
    private IEvaluationReference visibileRef;
    private IEvaluationReference lazyRef;
    private IEvaluationReference defaultInstanceRef;
    private final IEvaluationService evaluationService;
    private boolean lazy = true;
    private boolean active;
    private boolean defaultInstance;
    private boolean visible;
    private final ViewManagerContext viewManagerContext;
    private boolean suppressActiveEvent = false;
    protected final ViewInstanceDescriptor descriptor;

    public AbstractViewInstance(ViewManagerContext viewManagerContext, ViewInstanceDescriptor descriptor, IEvaluationService evaluationService) {
        this.viewManagerContext = viewManagerContext;
        this.evaluationService = evaluationService;
        this.descriptor = descriptor;
    }

    public void init() {
        this.attachVisibleExpression(this.descriptor, this.evaluationService);
        this.attachLazyExpression(this.descriptor, this.evaluationService);
        this.attachDefaultInstanceExpression(this.descriptor, this.evaluationService);
    }

    protected abstract void activateView();

    protected abstract void deactivateView();

    public void dispose() {
        this.deactivateView();
        if (this.visibileRef != null) {
            this.evaluationService.removeEvaluationListener(this.visibileRef);
            this.visibileRef = null;
        }
        if (this.lazyRef != null) {
            this.evaluationService.removeEvaluationListener(this.lazyRef);
            this.lazyRef = null;
        }
        if (this.defaultInstanceRef != null) {
            this.evaluationService.removeEvaluationListener(this.defaultInstanceRef);
            this.defaultInstanceRef = null;
        }
    }

    private void attachVisibleExpression(ViewInstanceDescriptor descriptor, IEvaluationService evaluationService) {
        if (descriptor.getVisibleExpression() != null) {
            this.visibileRef = evaluationService.addEvaluationListener(descriptor.getVisibleExpression(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (AbstractViewInstance.PROP_VISIBLE.equals(event.getProperty()) && event.getNewValue() instanceof Boolean) {
                        AbstractViewInstance.this.setVisibleState((Boolean)event.getNewValue());
                    }
                }
            }, PROP_VISIBLE);
        } else {
            this.setVisibleState(true);
        }
    }

    private void attachLazyExpression(ViewInstanceDescriptor descriptor, IEvaluationService evaluationService) {
        if (descriptor.getLazyExpression() != null) {
            this.lazyRef = evaluationService.addEvaluationListener(descriptor.getLazyExpression(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (AbstractViewInstance.PROP_LAZY.equals(event.getProperty()) && event.getNewValue() instanceof Boolean) {
                        AbstractViewInstance.this.setLazy((Boolean)event.getNewValue());
                    }
                }
            }, PROP_LAZY);
        } else {
            this.setLazy(false);
        }
    }

    private void attachDefaultInstanceExpression(ViewInstanceDescriptor descriptor, IEvaluationService evaluationService) {
        if (descriptor.getDefaultInstanceExpression() != null) {
            this.defaultInstanceRef = evaluationService.addEvaluationListener(descriptor.getDefaultInstanceExpression(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (AbstractViewInstance.PROP_DEFAULT_INSTANCE.equals(event.getProperty()) && event.getNewValue() instanceof Boolean) {
                        AbstractViewInstance.this.setDefaultInstance((Boolean)event.getNewValue());
                    }
                }
            }, PROP_DEFAULT_INSTANCE);
        } else {
            this.setDefaultInstance(descriptor.isDefaultInstance());
        }
    }

    @Override
    public ViewInstanceDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDefaultInstance(boolean defaultInstance) {
        this.defaultInstance = defaultInstance;
        this.fireDefaultStateChanged(defaultInstance);
    }

    @Override
    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    protected void setLazy(boolean lazy) {
        if (this.lazy == lazy) {
            return;
        }
        if (this.lazy) {
            this.activateView();
        } else if (!this.active) {
            this.deactivateView();
        }
        this.lazy = lazy;
        this.fireLazyStateChanged(lazy);
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisibleState(boolean state) {
        if (this.visible == state) {
            return;
        }
        this.visible = state;
        this.fireVisibleStateChanged(state);
    }

    private void fireVisibleStateChanged(boolean state) {
        if (this.viewManagerContext != null) {
            this.viewManagerContext.viewVisibilityChanged(this, state);
        }
    }

    private void fireLazyStateChanged(boolean state) {
        if (this.viewManagerContext != null) {
            this.viewManagerContext.viewLazynessChanged(this, state);
        }
    }

    private void fireDefaultStateChanged(boolean state) {
        if (this.viewManagerContext != null) {
            this.viewManagerContext.viewDefaultChanged(this, state);
        }
    }

    private void fireActiveStateChanged(boolean state) {
        if (this.viewManagerContext != null && !this.suppressActiveEvent) {
            this.viewManagerContext.viewActiveChanged(this, state);
        }
    }

    @Override
    public void reload() {
        try {
            this.suppressActiveEvent = true;
            this.deactivateView();
            this.activateView();
            this.fireControlChanged();
        }
        finally {
            this.suppressActiveEvent = false;
        }
    }

    private void fireControlChanged() {
        if (this.viewManagerContext != null) {
            this.viewManagerContext.viewControlChanged(this);
        }
    }

    @Override
    public void deactivate() {
        this.active = false;
        this.fireActiveStateChanged(false);
        if (this.lazy) {
            this.deactivateView();
        }
    }

    @Override
    public void activate() {
        this.active = true;
        this.fireActiveStateChanged(true);
        if (this.lazy) {
            this.activateView();
        }
    }
}

