/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.common.lib;

import java.util.Collection;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.common.CurrentTimeComponent;
import org.eclipse.scada.configuration.component.generator.AbstractDanglingGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.ScriptTimer;

public class CurrentTimeGenerator
extends AbstractDanglingGenerator {
    private final CurrentTimeComponent currentTime;

    public CurrentTimeGenerator(CurrentTimeComponent currentTime) {
        super((DataComponent)currentTime);
        this.currentTime = currentTime;
    }

    public void createItems(ItemCreator itemCreator) {
        ScriptItem item = OsgiFactory.eINSTANCE.createScriptItem();
        CodeFragment initCode = OsgiFactory.eINSTANCE.createCodeFragment();
        initCode.setCode(this.makeInit());
        item.setInitScript(initCode);
        CodeFragment timerCode = OsgiFactory.eINSTANCE.createCodeFragment();
        timerCode.setCode("DF.format ( new java.util.Date() );");
        ScriptTimer timer = OsgiFactory.eINSTANCE.createScriptTimer();
        timer.setPeriod(this.currentTime.getUpdatePeriod());
        timer.setScript(timerCode);
        item.setTimer(timer);
        CreationRequest req = itemCreator.addItem((Item)item);
        req.localTags((Collection)this.currentTime.getName());
        req.dataType(DataType.STRING);
        req.customizationTags(new String[]{"input"});
        req.information("Current time", null, "SCADA");
        this.createScriptItem(req);
    }

    private String makeInit() {
        if (this.currentTime.getDateFormat() == null || this.currentTime.getDateFormat().toString().isEmpty()) {
            return "var DF = new java.text.SimpleDateFormat ();";
        }
        return "var DF = new java.text.SimpleDateFormat (\"" + this.escape(this.currentTime.getDateFormat().toString()) + "\");";
    }

    private String escape(String string) {
        string = string.replace("\\", "\\\\");
        string = string.replace("\"", "\\\"");
        return string;
    }
}

