/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.ds;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;

public class DataStoreDataSource
extends AbstractDataSource
implements DataListener {
    private final Executor executor;
    private boolean disposed;
    private final DataNodeTracker dataNodeTracker;
    private final String id;
    private String nodeId;
    private final BundleContext context;

    public DataStoreDataSource(BundleContext context, String id, Executor executor, DataNodeTracker dataNodeTracker) {
        this.context = context;
        this.id = id;
        this.executor = executor;
        this.dataNodeTracker = dataNodeTracker;
        this.setError(null);
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantErrorFuture(new InvalidOperationException().fillInStackTrace());
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        if (this.dataNodeTracker.write(new DataNode(this.getNodeId(), (Serializable)value))) {
            return new InstantFuture((Object)WriteResult.OK);
        }
        return new InstantErrorFuture(new OperationException("Unable to write to data store! Data store missing!").fillInStackTrace());
    }

    private String getNodeId() {
        return this.nodeId;
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        if (this.disposed) {
            return;
        }
        if (this.nodeId != null) {
            this.dataNodeTracker.removeListener(this.nodeId, (DataListener)this);
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.nodeId = cfg.getString("node.id", "org.eclipse.scada.da.datasource.ds/" + this.id);
        this.dataNodeTracker.addListener(this.nodeId, (DataListener)this);
    }

    public synchronized void dispose() {
        this.disposed = true;
        if (this.nodeId != null) {
            this.dataNodeTracker.removeListener(this.nodeId, (DataListener)this);
            this.nodeId = null;
        }
    }

    public void nodeChanged(DataNode node) {
        logger.debug("Node data changed: {}", (Object)node);
        try {
            if (node != null) {
                Variant variant = (Variant)node.getDataAsObject(this.context.getBundle());
                DataItemValue.Builder builder = new DataItemValue.Builder();
                builder.setSubscriptionState(SubscriptionState.CONNECTED);
                builder.setValue(variant);
                this.updateData(builder.build());
            } else {
                DataItemValue.Builder builder = new DataItemValue.Builder();
                builder.setSubscriptionState(SubscriptionState.CONNECTED);
                builder.setValue(Variant.NULL);
                this.updateData(builder.build());
            }
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    private void setError(Throwable e) {
        logger.warn("Failed to read data", e);
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setSubscriptionState(SubscriptionState.CONNECTED);
        builder.setValue(Variant.NULL);
        builder.setAttribute("node.error", Variant.TRUE);
        if (e != null) {
            builder.setAttribute("node.error.message", Variant.valueOf((Object)e.getMessage()));
        }
        this.updateData(builder.build());
    }
}

