/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.DocumentRoot;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.exporter.ExportType;
import org.eclipse.scada.da.server.exporter.ExporterPackage;
import org.eclipse.scada.da.server.exporter.HiveType;
import org.eclipse.scada.da.server.exporter.NetExport;
import org.eclipse.scada.da.server.exporter.NgpExport;
import org.eclipse.scada.da.server.exporter.util.ExporterResourceFactoryImpl;
import org.eclipse.scada.da.server.ui.HivesPlugin;
import org.eclipse.scada.da.server.ui.HostedServer;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.da.server.ui.ServerHost;
import org.eclipse.scada.da.server.ui.internal.BundleContextHiveFactory;
import org.eclipse.scada.da.server.ui.util.ServerDescriptorImpl;
import org.eclipse.scada.ui.utils.status.StatusHelper;

public class ServerHostImpl
implements ServerHost {
    private final Realm realm;
    private final Set<ServerDescriptorImpl> servers = new HashSet<ServerDescriptorImpl>();

    public ServerHostImpl(Realm realm) {
        this.realm = realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(HostedServerDescriptor server) {
        boolean doUnregister;
        Set<ServerDescriptorImpl> set = this.servers;
        synchronized (set) {
            doUnregister = this.servers.remove(server);
        }
        if (doUnregister) {
            HivesPlugin.unregisterServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ServerDescriptorImpl> toDispose;
        ServerHostImpl serverHostImpl = this;
        synchronized (serverHostImpl) {
            toDispose = new ArrayList<ServerDescriptorImpl>(this.servers);
            this.servers.clear();
        }
        this.realm.asyncExec(new Runnable(){

            @Override
            public void run() {
                for (ServerDescriptorImpl server : toDispose) {
                    HivesPlugin.unregisterServer(server);
                    server.dispose();
                }
            }
        });
    }

    @Override
    public Collection<? extends ServerDescriptor> startServer(IFile exporterFile) throws CoreException {
        String label = exporterFile.getFullPath().toString();
        return this.startServer(URI.createURI((String)exporterFile.getLocationURI().toString()), label);
    }

    @Override
    public Collection<? extends ServerDescriptor> startServer(String exporterFileUri) throws CoreException {
        return this.startServer(URI.createURI((String)exporterFileUri));
    }

    @Override
    public Collection<? extends ServerDescriptor> startServer(URI exporterFileUri) throws CoreException {
        return this.startServer(exporterFileUri, exporterFileUri.toString());
    }

    public Collection<? extends ServerDescriptor> startServer(URI exporterFileUri, String locationLabel) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ExporterResourceFactoryImpl());
        Resource resource = resourceSet.createResource(exporterFileUri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (String)"Failed to load configuration", (Throwable)e));
        }
        DocumentRoot root = (DocumentRoot)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ExporterPackage.Literals.DOCUMENT_ROOT);
        if (root == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui", "Failed to locate exporter configuration in: " + exporterFileUri));
        }
        return this.startServer(root, locationLabel);
    }

    @Override
    public Collection<? extends ServerDescriptor> startServer(DocumentRoot root, String locationLabel) throws CoreException {
        try {
            LinkedList<HostedServerDescriptor> descriptors = new LinkedList<HostedServerDescriptor>();
            for (HiveType hive : root.getConfiguration().getHive()) {
                Hive hiveImpl = this.createHive(hive.getRef(), hive.getConfiguration().getAny());
                HashSet<Export> exporters = new HashSet<Export>();
                for (ExportType export : hive.getExport()) {
                    Export exporter = this.createExporter(hiveImpl, export.getUri());
                    if (exporter == null) continue;
                    exporters.add(exporter);
                }
                HostedServerDescriptor desc = new HostedServerDescriptor(this.realm, hiveImpl, exporters, locationLabel);
                HivesPlugin.registerServer(desc);
                this.servers.add(desc);
                descriptors.add(desc);
            }
            return descriptors;
        }
        catch (Exception e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (String)"Failed to start", (Throwable)e));
        }
    }

    private Export createExporter(Hive hive, String uri) throws Exception {
        ConnectionInformation ci = ConnectionInformation.fromURI((String)uri);
        if (!ci.getInterface().equals("da")) {
            throw new IllegalArgumentException(String.format("Only the interface 'da' may be used (%s)", ci.getInterface()));
        }
        String driver = ci.getDriver();
        if ("ngp".equals(driver)) {
            return new NgpExport(hive, ci);
        }
        if ("net".equals(driver)) {
            return new NetExport(hive, ci);
        }
        throw new IllegalArgumentException(String.format("Illegal protocol used '%s' (only 'net' and 'ngp' are allowed)", driver));
    }

    private Hive createHive(String ref, FeatureMap featureMap) throws Exception {
        FeatureMap.Entry first = (FeatureMap.Entry)featureMap.get(0);
        BundleContextHiveFactory factory = new BundleContextHiveFactory(HivesPlugin.getDefault().getBundle().getBundleContext());
        return factory.createHive(ref, (EObject)first.getValue());
    }

    private final class HostedServerDescriptor
    extends ServerDescriptorImpl
    implements HostedServer {
        private HostedServerDescriptor(Realm realm, Hive hive, Set<Export> exporters, String labelAddition) {
            super(realm, hive, exporters, labelAddition);
        }

        @Override
        public void dispose() {
            ServerHostImpl.this.removeServer(this);
            super.dispose();
        }
    }
}

