/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.internal;

import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.da.server.ui.HivesPlugin;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.da.server.ui.ServerEndpoint;
import org.eclipse.scada.ui.databinding.ObservableMapStyledCellLabelProvider;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.swt.graphics.Image;

public class ServerLabelProvider
extends ObservableMapStyledCellLabelProvider {
    private final Image errorImage = HivesPlugin.getDefault().getImageRegistry().get("error");
    private final Image runningImage = HivesPlugin.getDefault().getImageRegistry().get("running");
    private final Image stoppedImage = HivesPlugin.getDefault().getImageRegistry().get("stopped");

    public ServerLabelProvider(IObservableSet knownElements) {
        super(new IObservableMap[]{BeanProperties.value((String)"running").observeDetail(knownElements), BeanProperties.value((String)"error").observeDetail(knownElements)});
    }

    public void update(ViewerCell cell) {
        Object ele = cell.getElement();
        if (ele instanceof ServerDescriptor) {
            this.update(cell, (ServerDescriptor)ele);
        } else if (ele instanceof ServerEndpoint) {
            this.update(cell, (ServerEndpoint)ele);
        }
    }

    protected void update(ViewerCell cell, ServerDescriptor element) {
        StyledString str = new StyledString();
        boolean running = element.isRunning();
        str.append(element.getLabel());
        String add = element.getAdditionalLabe();
        if (add != null) {
            str.append(' ');
            str.append(add, StyledString.QUALIFIER_STYLER);
        }
        cell.setText(str.getString());
        cell.setStyleRanges(str.getStyleRanges());
        if (element.getError() != null) {
            cell.setImage(this.errorImage);
        } else {
            cell.setImage(running ? this.runningImage : this.stoppedImage);
        }
    }

    protected void update(ViewerCell cell, ServerEndpoint element) {
        StyledString str = new StyledString();
        boolean running = element.isRunning();
        str.append(element.getLabel());
        cell.setText(str.getString());
        cell.setStyleRanges(str.getStyleRanges());
        if (element.getError() != null) {
            cell.setImage(this.errorImage);
        } else {
            cell.setImage(running ? this.runningImage : this.stoppedImage);
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof ServerDescriptor) {
            return ExceptionHelper.formatted((Throwable)((ServerDescriptor)element).getError());
        }
        if (element instanceof ServerEndpoint) {
            return ExceptionHelper.formatted((Throwable)((ServerEndpoint)element).getError());
        }
        return super.getToolTipText(element);
    }

    public Image getToolTipImage(Object element) {
        if (element instanceof ServerDescriptor) {
            return ((ServerDescriptor)element).getError() == null ? null : this.errorImage;
        }
        if (element instanceof ServerEndpoint) {
            return ((ServerEndpoint)element).getError() == null ? null : this.errorImage;
        }
        return super.getToolTipImage(element);
    }
}

