/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.internal;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scada.da.server.ui.HivesPlugin;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.da.server.ui.ServerManager;
import org.eclipse.scada.da.server.ui.internal.ServerLabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;

public class ServersViewer {
    private final TreeViewer viewer;
    private final ObservableSetTreeContentProvider contentProvider;
    private final ServerLabelProvider labelProvider;

    public ServersViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 770);
        this.contentProvider = new ObservableSetTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ServerLabelProvider(this.contentProvider.getKnownElements());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)HivesPlugin.getDefault().getServerManager());
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ServersViewer.this.handleDispose();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
    }

    protected void handleDispose() {
        this.contentProvider.dispose();
        this.labelProvider.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void contributeTo(IWorkbenchPartSite site) {
        site.setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(site);
    }

    private void hookContextMenu(IWorkbenchPartSite site) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ServersViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static final class ObservableFactoryImpl
    implements IObservableFactory {
        private ObservableFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof ServerManager) {
                return Observables.proxyObservableSet((IObservableSet)((ServerManager)target).getServers());
            }
            if (target instanceof ServerDescriptor) {
                return Observables.proxyObservableSet((IObservableSet)((ServerDescriptor)target).getEndpoints());
            }
            return null;
        }
    }
}

