/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.ui.ServerEndpoint;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndpointImpl
extends AbstractPropertyChange
implements ServerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ServerEndpointImpl.class);
    private boolean running;
    private final Export endpoint;
    private Throwable error;

    public ServerEndpointImpl(Export endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void stop() throws CoreException {
        try {
            this.endpoint.stop();
            this.setRunning(false);
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e);
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (Throwable)e));
        }
    }

    @Override
    public void start() throws CoreException {
        try {
            this.endpoint.start();
            this.setRunning(true);
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e);
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (Throwable)e));
        }
    }

    @Override
    public String getLabel() {
        return this.endpoint.getConnectionInformation().toString();
    }

    protected void setRunning(boolean running) {
        this.running = running;
        this.firePropertyChange("running", this.running, this.running);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setError(Throwable error) {
        this.error = error;
        this.firePropertyChange("error", this.error, this.error);
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public void dispose() {
        try {
            this.endpoint.stop();
        }
        catch (Exception exception) {
            logger.warn("Failed to stop endpoint when disposing");
        }
    }
}

