/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.chart;

import org.eclipse.scada.chart.swt.ChartArea;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.VisibilityController;
import org.eclipse.scada.da.client.dataitem.details.chart.Messages;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.DataItemSeries;
import org.eclipse.scada.ui.chart.model.IdItem;
import org.eclipse.scada.ui.chart.model.Item;
import org.eclipse.scada.ui.chart.model.UriItem;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.CompositeExtensionSpace;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.utils.layout.GridLayoutFactory;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailsPart
implements org.eclipse.scada.da.client.dataitem.details.part.DetailsPart {
    private static final Logger logger = LoggerFactory.getLogger(DetailsPart.class);
    private Button startButton;
    private Composite wrapper;
    private org.eclipse.scada.da.ui.connection.data.Item item;
    private ChartViewer chart;
    private ChartArea chartArea;
    private Composite extensionSpace;

    public void createPart(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.createButton(parent);
    }

    private void createButton(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.wrapper.setLayout((Layout)layout);
        this.startButton = new Button(this.wrapper, 8);
        this.startButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.startButton.setText(Messages.DetailsPart_startButton_label);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DetailsPart.this.start();
                }
                catch (Exception ex) {
                    logger.error("Failed to start chart", (Throwable)ex);
                    StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.da.client.dataitem.details.chart", (Throwable)ex), 4);
                }
            }
        });
    }

    public void dispose() {
        if (this.chartArea != null) {
            this.chartArea.dispose();
            this.chartArea = null;
        }
        if (this.chart != null) {
            this.chart.dispose();
            this.chart = null;
        }
    }

    protected void start() {
        IdItem item;
        this.startButton.dispose();
        this.startButton = null;
        if (this.item == null) {
            return;
        }
        switch (this.item.getType()) {
            case ID: {
                item = ChartFactory.eINSTANCE.createIdItem();
                item.setConnectionId(this.item.getConnectionString());
                break;
            }
            case URI: {
                item = ChartFactory.eINSTANCE.createUriItem();
                ((UriItem)item).setConnectionUri(this.item.getConnectionString());
                break;
            }
            default: {
                return;
            }
        }
        item.setItemId(this.item.getId());
        Chart chartModel = ChartFactory.eINSTANCE.createChart();
        chartModel.setMutable(false);
        chartModel.setShowCurrentTimeRuler(true);
        chartModel.setTitle(Messages.DetailsPart_ChartModel_title);
        XAxis x = ChartFactory.eINSTANCE.createXAxis();
        x.setLabel(Messages.DetailsPart_ChartModel_x_label);
        x.setFormat(Messages.DetailsPart_ChartModel_x_format);
        x.setMinimum(System.currentTimeMillis());
        x.setMaximum(System.currentTimeMillis() + 900000L);
        YAxis y = ChartFactory.eINSTANCE.createYAxis();
        y.setLabel(Messages.DetailsPart_ChartModel_y_label);
        y.setMinimum(-100.0);
        y.setMaximum(100.0);
        chartModel.setSelectedXAxis(x);
        chartModel.setSelectedYAxis(y);
        chartModel.getControllers().add((Object)ChartFactory.eINSTANCE.createMouseController());
        chartModel.getControllers().add((Object)ChartFactory.eINSTANCE.createTimeNowAction());
        DataItemSeries dataItemSeries = ChartFactory.eINSTANCE.createDataItemSeries();
        dataItemSeries.setX(x);
        dataItemSeries.setY(y);
        dataItemSeries.setLabel(item.getItemId());
        dataItemSeries.setItem((Item)item);
        chartModel.getBottom().add((Object)x);
        chartModel.getLeft().add((Object)y);
        chartModel.getInputs().add((Object)dataItemSeries);
        this.wrapper.setLayout((Layout)GridLayoutFactory.slimStack());
        this.extensionSpace = new Composite(this.wrapper, 0);
        this.extensionSpace.setLayoutData((Object)new GridData(4, 4, true, false));
        this.extensionSpace.setLayout((Layout)new RowLayout(256));
        this.chartArea = new ChartArea(this.wrapper, 0);
        this.chartArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chart = new ChartViewer(this.chartArea.getChartRenderer(), chartModel, (ExtensionSpaceProvider)new CompositeExtensionSpace(this.extensionSpace), null);
        this.wrapper.layout();
    }

    public void setDataItem(DataItemHolder item) {
        this.item = item != null ? item.getItem() : null;
    }

    public void updateData(DataItemValue value) {
    }

    public void setVisibilityController(VisibilityController visibilityController) {
        visibilityController.show();
    }
}

