/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.RealtimeListAdapter;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDropAdapter
extends ViewerDropAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ItemDropAdapter.class);
    private final RealtimeListAdapter list;

    public ItemDropAdapter(Viewer viewer, RealtimeListAdapter list) {
        super(viewer);
        this.list = list;
        this.setFeedbackEnabled(true);
        this.setSelectionFeedbackEnabled(true);
    }

    public boolean performDrop(Object data) {
        logger.debug("Dropping: {}", data);
        if (data instanceof Item[]) {
            this.dropItems((Item[])data);
            return true;
        }
        if (data instanceof String) {
            this.dropString(data);
            return true;
        }
        return false;
    }

    private void dropString(Object data) {
        String[] toks;
        TreeViewer viewer = (TreeViewer)this.getViewer();
        String[] stringArray = toks = ((String)data).split("[\\n\\r]+");
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            try {
                Item item;
                String[] stoks;
                URI uri = new URI(tok);
                if (uri.getScheme() == null) {
                    stoks = tok.split("#");
                    item = new Item(stoks[0], this.decodeItemId(stoks[1]), Item.Type.ID);
                    this.dropItem(item, viewer);
                } else if (uri.getFragment() != null) {
                    stoks = tok.split("#", 2);
                    item = new Item(stoks[0], this.decodeItemId(uri.getFragment()), Item.Type.URI);
                    this.dropItem(item, viewer);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                String[] stoks = tok.split("#");
                Item item = new Item(stoks[0], this.decodeItemId(stoks[1]), Item.Type.ID);
                this.dropItem(item, viewer);
            }
            ++n2;
        }
    }

    private String decodeItemId(String itemId) {
        try {
            return URLDecoder.decode(itemId, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return itemId;
        }
    }

    private void dropItems(Item[] items) {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            this.dropItem(item, viewer);
            ++n2;
        }
    }

    private void dropItem(Item item, TreeViewer viewer) {
        logger.info("Dropped item: {} ({})", (Object)item, (Object)item.getType());
        ListEntry entry = new ListEntry();
        entry.setDataItem(new Item(item));
        this.list.add(entry);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferData) {
        if (ItemTransfer.getInstance().isSupportedType(transferData)) {
            return true;
        }
        return TextTransfer.getInstance().isSupportedType(transferData);
    }
}

