/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.common.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.server.Session;
import org.eclipse.scada.hd.server.common.internal.QueryImpl;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
extends AbstractSessionImpl
implements Session,
ItemListListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private final HashMap<String, HistoricalItemInformation> itemCache = new HashMap();
    private final Collection<QueryImpl> queries = new LinkedList<QueryImpl>();
    private ItemListListener itemListListener;

    public SessionImpl(UserInformation user, Map<String, String> properties) {
        super(user, properties);
        logger.info("Created new session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        logger.info("Disposing session");
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            ArrayList<QueryImpl> queries = new ArrayList<QueryImpl>(this.queries);
            for (QueryImpl query : queries) {
                query.dispose();
            }
            this.queries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemListListener(ItemListListener itemListListener) {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.itemListListener = itemListListener;
            if (itemListListener != null) {
                this.fireListChanged(new HashSet<HistoricalItemInformation>(this.itemCache.values()), null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (full) {
                this.itemCache.clear();
            }
            if (removed != null && !full) {
                for (String string : removed) {
                    this.itemCache.remove(string);
                }
            }
            if (addedOrModified != null) {
                for (HistoricalItemInformation historicalItemInformation : addedOrModified) {
                    this.itemCache.put(historicalItemInformation.getItemId(), historicalItemInformation);
                }
            }
            this.fireListChanged(addedOrModified, removed, full);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListChanged(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this.itemListListener != null) {
                this.itemListListener.listChanged(addedOrModified, removed, full);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(QueryImpl query) {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.queries.add(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(QueryImpl query) {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.queries.remove(query);
        }
    }
}

