/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.importer.hsdb;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.importer.hsdb.HSDBValueSource;
import org.eclipse.scada.hd.server.storage.common.QueryImpl;
import org.eclipse.scada.hd.server.storage.common.ValueSourceManager;
import org.eclipse.scada.hds.ValueVisitor;

public class HSDBHistoricalItem
implements HistoricalItem,
ValueSourceManager {
    private final HistoricalItemInformation information;
    private final ScheduledExecutorService executor;
    private final HSDBValueSource source;
    private Set<QueryImpl> queries = new HashSet<QueryImpl>();

    public HSDBHistoricalItem(ScheduledExecutorService executor, HSDBValueSource source, HistoricalItemInformation information) {
        this.executor = executor;
        this.information = information;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(QueryParameters parameters, QueryListener listener, boolean updateData) {
        QueryImpl query = new QueryImpl((ValueSourceManager)this, this.executor, this.executor, parameters, listener, updateData, this.source.getStartTimestamp(), this.source.getEndTimestamp());
        HSDBHistoricalItem hSDBHistoricalItem = this;
        synchronized (hSDBHistoricalItem) {
            block4: {
                if (this.queries != null) break block4;
                query.close();
                return null;
            }
            this.queries.add(query);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<QueryImpl> queries;
        HSDBHistoricalItem hSDBHistoricalItem = this;
        synchronized (hSDBHistoricalItem) {
            queries = this.queries;
            this.queries = null;
        }
        for (QueryImpl query : queries) {
            query.close();
        }
    }

    public HistoricalItemInformation getInformation() {
        return this.information;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryClosed(QueryImpl query) {
        HSDBHistoricalItem hSDBHistoricalItem = this;
        synchronized (hSDBHistoricalItem) {
            if (this.queries != null) {
                this.queries.remove(query);
            }
        }
    }

    public boolean visit(QueryParameters parameters, ValueVisitor visitor) {
        return this.source.visit(visitor, new Date(parameters.getStartTimestamp()), new Date(parameters.getEndTimestamp()));
    }
}

