/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.importer.hsdb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.scada.hds.AbstractValueSource;
import org.eclipse.scada.hds.ValueVisitor;
import org.eclipse.scada.utils.lang.Immutable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSDBValueSource
extends AbstractValueSource {
    private static final Logger logger = LoggerFactory.getLogger(HSDBValueSource.class);
    private final File root;
    private final Collection<FileEntry> entries;
    private final Date startTimestamp;
    private final Date endTimestamp;

    public HSDBValueSource(BundleContext context, File root, String name) throws FileNotFoundException, IOException {
        this.root = root;
        Properties p = new Properties();
        p.load(new FileInputStream(new File(root, String.valueOf(name) + ".va_ctrl")));
        int numEntries = Integer.parseInt(p.getProperty("hsdb.manager.knownFragmentsCount"));
        Date startTimestamp = null;
        Date endTimestamp = null;
        this.entries = new LinkedList<FileEntry>();
        int i = 0;
        while (i < numEntries) {
            FileEntry file = this.makeFile(p, i);
            if (file != null) {
                if (startTimestamp == null || startTimestamp.after(file.getStartTimestamp())) {
                    startTimestamp = file.getStartTimestamp();
                }
                if (endTimestamp == null || endTimestamp.before(file.getEndTimestamp())) {
                    endTimestamp = file.getStartTimestamp();
                }
                this.entries.add(file);
            }
            ++i;
        }
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    private FileEntry makeFile(Properties p, int i) {
        String level = p.getProperty("hsdb.manager.knownFragment.compressionLevel." + i);
        if (!"0".equals(level)) {
            logger.info("Ignoring compression levels ({})", (Object)level);
            return null;
        }
        long start = Long.parseLong(p.getProperty("hsdb.manager.knownFragment.startTime." + i));
        long end = Long.parseLong(p.getProperty("hsdb.manager.knownFragment.endTime." + i));
        File file = new File(this.root, new File(p.getProperty("hsdb.manager.knownFragment.name." + i)).getName());
        if (!file.canRead()) {
            logger.warn("File {} not found.", (Object)file);
        }
        return new FileEntry(new Date(start), new Date(end), file);
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public boolean visit(ValueVisitor visitor, Date start, Date end) {
        logger.debug("Visiting - start: {}, end: {}", (Object)start, (Object)end);
        FileEntry first = null;
        for (FileEntry entry : this.entries) {
            logger.debug("File - start: {}, end: {}", (Object)entry.getStartTimestamp(), (Object)entry.getEndTimestamp());
            if (entry.getEndTimestamp().before(start)) {
                logger.debug("Before start. Skipping... for now");
                if (first != null && !first.endTimestamp.before(entry.getEndTimestamp())) continue;
                logger.debug("Remember for previous file: {}", (Object)entry.getFile());
                first = entry;
                continue;
            }
            if (entry.getStartTimestamp().after(end)) {
                logger.debug("After end. Skipping...");
                continue;
            }
            if (this.visitFile(entry, visitor)) continue;
            return false;
        }
        if (first != null) {
            logger.debug("Visiting previous file: {}", first);
            return this.visitFile(first, visitor);
        }
        return true;
    }

    protected boolean visitFile(FileEntry entry, ValueVisitor visitor) {
        try {
            logger.debug("Visiting file: {}", (Object)entry.getFile());
            return this.parseFile(entry, visitor);
        }
        catch (Exception e) {
            logger.warn("Failed reading " + entry.getFile(), (Throwable)e);
            return visitor.value(Double.NaN, entry.getStartTimestamp(), true, false);
        }
    }

    private boolean parseFile(FileEntry entry, ValueVisitor visitor) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(entry.getFile()));
        try {
            byte[] header = new byte[16];
            if (((InputStream)input).read(header) != header.length) {
                throw new IOException("Corrupt header");
            }
            ByteBuffer headerBuffer = ByteBuffer.wrap(header);
            headerBuffer.getLong();
            long dataStart = headerBuffer.getLong();
            if (dataStart <= (long)header.length) {
                throw new IOException("Illegal data start address");
            }
            ((InputStream)input).skip(dataStart - (long)header.length);
            byte[] recordArray = new byte[41];
            ByteBuffer record = ByteBuffer.wrap(recordArray);
            while (((InputStream)input).read(record.array()) == recordArray.length) {
                byte parityCalc = 90;
                int i = 0;
                while (i < 40) {
                    parityCalc = (byte)(parityCalc ^ record.get(i));
                    ++i;
                }
                Date timestamp = new Date(record.getLong());
                long quality = record.getLong();
                long manual = record.getLong();
                record.getLong();
                double value = record.getDouble();
                byte parity = record.get();
                record.clear();
                if (parity != parityCalc) {
                    logger.warn("Parity does not match - read: {}, calc: {}", (Object)parity, (Object)parityCalc);
                    continue;
                }
                logger.trace("Visiting value - timestamp: {}, value: {}", (Object)timestamp, (Object)value);
                if (visitor.value(value, timestamp, quality == 100L, manual != 0L)) continue;
                return false;
            }
            return true;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public void dispose() {
    }

    @Immutable
    private static class FileEntry {
        private final Date startTimestamp;
        private final Date endTimestamp;
        private final File file;

        public FileEntry(Date startTimestamp, Date endTimestamp, File file) {
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public Date getEndTimestamp() {
            return this.endTimestamp;
        }

        public Date getStartTimestamp() {
            return this.startTimestamp;
        }
    }
}

