/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.lib;

import org.eclipse.scada.configuration.component.exec.ExecJob;
import org.eclipse.scada.configuration.component.exec.lib.ExecJobGenerator;
import org.eclipse.scada.configuration.component.exec.lib.Helper;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.da.exec.configuration.ConfigurationFactory;
import org.eclipse.scada.da.exec.configuration.FieldExtractorType;
import org.eclipse.scada.da.exec.configuration.FieldType;
import org.eclipse.scada.da.exec.configuration.VariantTypeType;

public abstract class AbstractFieldJobGenerator
extends ExecJobGenerator {
    private final ExecJob execJob;

    protected abstract ItemSpec[] getItems();

    public void createItems(ItemCreator itemCreator) {
        ItemSpec[] itemSpecArray = this.getItems();
        int n = itemSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemSpec item = itemSpecArray[n2];
            if (item.getSourcePart() != null) {
                CreationRequest c = itemCreator.createSourceItem(this.execJob.getRunsOn(), this.localItem(item.getFullLocal()));
                c.localTags(item.getLocalPart()).information(item.getDescription(), item.getUnit(), null);
                c.dataType(item.getDataType()).customizationTags(item.getCustomizationTags());
                c.create();
            }
            ++n2;
        }
    }

    public AbstractFieldJobGenerator(ExecJob execJob) {
        super(execJob);
        this.execJob = execJob;
    }

    protected void createItemFieldsFor(FieldExtractorType ext) {
        ItemSpec[] itemSpecArray = this.getItems();
        int n = itemSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemSpec item = itemSpecArray[n2];
            if (item.getExtractorName().equals(ext.getName())) {
                this.createField(ext, item.getSourcePart(), Helper.convert(item.getDataType()));
            }
            ++n2;
        }
    }

    protected void createField(FieldExtractorType ext, String name, VariantTypeType variantType) {
        FieldType field = ConfigurationFactory.eINSTANCE.createFieldType();
        field.setName(name);
        field.setVariantType(variantType);
        ext.getField().add((Object)field);
    }

    protected abstract void generateExecDriverConfiguration();

    public void generate(GenerationContext context) {
        super.generate(context);
        this.generateExecDriverConfiguration();
    }

    protected static class ItemSpec {
        private final String extractorName;
        private final String sourcePart;
        private final DataType dataType;
        private final String[] localPart;
        private final String[] customizationTags;
        private final String description;
        private final String unit;

        protected ItemSpec(String extractorName, String sourcePart, DataType dataType, String description, String unit, String[] localPart, String[] customizationTags) {
            this.extractorName = extractorName;
            this.sourcePart = sourcePart;
            this.dataType = dataType;
            this.localPart = (String[])localPart.clone();
            this.customizationTags = (String[])customizationTags.clone();
            this.description = description;
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtractorName() {
            return this.extractorName;
        }

        public String getSourcePart() {
            return this.sourcePart;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String[] getLocalPart() {
            return this.localPart;
        }

        public String[] getCustomizationTags() {
            return this.customizationTags;
        }

        public String getFullLocal() {
            return String.format("%s.%s", this.extractorName, this.sourcePart);
        }
    }
}

