/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.lib;

import org.eclipse.scada.configuration.component.exec.ExecComponentsPackage;
import org.eclipse.scada.configuration.component.exec.ExecJob;
import org.eclipse.scada.configuration.component.exec.PingCheck;
import org.eclipse.scada.configuration.component.exec.PingCheckConfiguration;
import org.eclipse.scada.configuration.component.exec.lib.ExecJobGenerator;
import org.eclipse.scada.configuration.component.exec.lib.PingCheckWriter;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.DataType;

public class PingCheckGenerator
extends ExecJobGenerator {
    private final PingCheck pingCheck;

    public PingCheckGenerator(PingCheck pingCheck) {
        super((ExecJob)pingCheck);
        this.pingCheck = pingCheck;
    }

    public void generate(GenerationContext context) {
        PingCheckConfiguration cfg = (PingCheckConfiguration)this.findConfiguration(PingCheckConfiguration.class, ExecComponentsPackage.Literals.PING_CHECK_CONFIGURATION);
        PingCheckWriter writer = PingCheckWriter.find(cfg, this.findRoot(), this.context);
        writer.addEntry(this.pingCheck.getNode().getHostName(), this.makeSourceName());
        super.generate(context);
    }

    protected String makeSourceName() {
        return String.valueOf(this.getFullLevelName()) + "." + this.pingCheck.getNode().getHostName();
    }

    public void createItems(ItemCreator creator) {
        CreationRequest c = creator.createSourceItem(this.pingCheck.getRunsOn(), "PING.values." + this.makeSourceName() + ".reach");
        c.localTags(new String[]{"REACH"}).dataType(DataType.FLOAT).customizationTags(new String[]{"input"});
        c.information(String.format("Reachability of %s", this.pingCheck.getNode().getHostName()), null, null);
        c.create();
        c = creator.createSourceItem(this.pingCheck.getRunsOn(), "PING.values." + this.makeSourceName() + ".rtt");
        c.localTags(new String[]{"RTT"}).dataType(DataType.INT32).customizationTags(new String[]{"input"});
        c.information(String.format("Round trip time to %s", this.pingCheck.getNode().getHostName()), "ms", null);
        c.create();
    }

    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master) {
        super.generateForMaster(context, master);
        this.addDebianDependency(master.getImplementation(), "eclipse-scada-ping");
    }
}

