/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.lib;

import org.eclipse.scada.configuration.component.exec.ExecJob;
import org.eclipse.scada.configuration.component.exec.SystemInformationVMStat;
import org.eclipse.scada.configuration.component.exec.lib.AbstractFieldJobGenerator;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.da.exec.configuration.ConfigurationFactory;
import org.eclipse.scada.da.exec.configuration.EnvEntryType;
import org.eclipse.scada.da.exec.configuration.FieldExtractorType;
import org.eclipse.scada.da.exec.configuration.ProcessType;
import org.eclipse.scada.da.exec.configuration.RootType;
import org.eclipse.scada.da.exec.configuration.SplitContinuousCommandType;
import org.eclipse.scada.da.exec.configuration.SplitterExtractorType;
import org.eclipse.scada.da.exec.configuration.SplitterType;

public class SystemInformationVMStatGenerator
extends AbstractFieldJobGenerator {
    public SystemInformationVMStatGenerator(SystemInformationVMStat configuration) {
        super((ExecJob)configuration);
    }

    @Override
    protected AbstractFieldJobGenerator.ItemSpec[] getItems() {
        return new AbstractFieldJobGenerator.ItemSpec[]{new AbstractFieldJobGenerator.ItemSpec("A", "procs.run", DataType.INT64, "The number of processes waiting for run time", null, new String[]{"PROCS", "RUN"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "procs.blocked", DataType.INT64, "The number of processes in uninterruptible sleep", null, new String[]{"PROCS", "BLOCKED"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "memory.swpd", DataType.INT64, "The amount of virtual memory used", "KiB", new String[]{"MEM", "SWAPPED"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "memory.free", DataType.INT64, "The amount of idle memory", "KiB", new String[]{"MEM", "FREE"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "memory.buff", DataType.INT64, "The amount of memory used as buffers", "KiB", new String[]{"MEM", "BUFFER"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "memory.cache", DataType.INT64, "The amount of memory used as cache", "KiB", new String[]{"MEM", "CACHE"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "swap.in", DataType.INT64, "Amount of memory swapped in from disk", "/s", new String[]{"SWAP", "IN"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "swap.out", DataType.INT64, "Amount of memory swapped out from disk", "/s", new String[]{"SWAP", "OUT"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "block.in", DataType.INT64, "Blocks received from a block device", "/s", new String[]{"BLOCK", "IN"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "block.out", DataType.INT64, "Blocks sent to a block device", "/s", new String[]{"BLOCK", "OUT"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "system.in", DataType.INT64, "The number of interrupts per second, including the clock", "int/s", new String[]{"SYS", "INT"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "system.cs", DataType.INT64, "The number of context switches per second", "cs/s", new String[]{"SYS", "CS"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "cpu.us", DataType.FLOAT, "Time spent running non-kernel code", "%", new String[]{"CPU", "USER"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "cpu.sy", DataType.FLOAT, "Time spent running kernel code", "%", new String[]{"CPU", "SYS"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "cpu.id", DataType.FLOAT, "Time spent idle", "%", new String[]{"CPU", "IDLE"}, new String[]{"input"}), new AbstractFieldJobGenerator.ItemSpec("A", "cpu.wa", DataType.FLOAT, "Time spent waiting for IO", "%", new String[]{"CPU", "WAIT"}, new String[]{"input"})};
    }

    @Override
    protected void generateExecDriverConfiguration() {
        RootType root = this.findRoot();
        SplitContinuousCommandType cmd = ConfigurationFactory.eINSTANCE.createSplitContinuousCommandType();
        cmd.setId(this.jobName());
        cmd.setRestartDelay(1000);
        cmd.setMaxInputBuffer(2000);
        cmd.setIgnoreStartLines(2);
        root.getCommand().add((Object)cmd);
        ProcessType process = ConfigurationFactory.eINSTANCE.createProcessType();
        process.setExec("vmstat");
        process.getArgument().add((Object)"-n");
        process.getArgument().add((Object)"1");
        cmd.setProcess(process);
        EnvEntryType env = ConfigurationFactory.eINSTANCE.createEnvEntryType();
        env.setName("LANG");
        env.setValue("en_US");
        process.getEnv().add((Object)env);
        SplitterType splitter = ConfigurationFactory.eINSTANCE.createSplitterType();
        splitter.setType("newline");
        cmd.setSplitter(splitter);
        SplitterExtractorType ext = ConfigurationFactory.eINSTANCE.createSplitterExtractorType();
        ext.setSplitExpression(" ");
        ext.setName("A");
        cmd.getExtractor().add((Object)ext);
        this.createItemFieldsFor((FieldExtractorType)ext);
    }
}

