/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.FormulaItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.TypedItemReference;

public abstract class AbstractDanglingGenerator
extends DataComponentGenerator {
    private final Map<MasterServer, ScriptItem> danglingScriptItemMap = new HashMap<MasterServer, ScriptItem>();
    private final Map<MasterServer, FormulaItem> danglingFormulaItemMap = new HashMap<MasterServer, FormulaItem>();

    public AbstractDanglingGenerator(DataComponent component) {
        super(component);
    }

    protected ScriptItem createScriptItem(CreationRequest<ScriptItem> req) {
        req.addMasterListener((MasterListener)new MasterListener<ScriptItem>(){

            public void setMaster(ScriptItem item, GeneratorContext.MasterContext master) {
                AbstractDanglingGenerator.this.danglingScriptItemMap.put(master.getImplementation(), item);
            }
        });
        return (ScriptItem)req.create();
    }

    protected FormulaItem createFormulaItem(CreationRequest<FormulaItem> req) {
        req.addMasterListener((MasterListener)new MasterListener<FormulaItem>(){

            public void setMaster(FormulaItem item, GeneratorContext.MasterContext master) {
                AbstractDanglingGenerator.this.danglingFormulaItemMap.put(master.getImplementation(), item);
            }
        });
        return (FormulaItem)req.create();
    }

    @Override
    public void finish(FinishContext context) {
        ScriptItem item;
        MasterServer master;
        super.finish(context);
        for (Map.Entry<MasterServer, ScriptItem> entry : this.danglingScriptItemMap.entrySet()) {
            master = entry.getKey();
            item = entry.getValue();
            for (ItemReference input : item.getInputs()) {
                input.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)input.getItem()));
            }
            for (ItemReference command : item.getCommands()) {
                command.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)command.getItem()));
            }
        }
        for (Map.Entry<MasterServer, ScriptItem> entry : this.danglingFormulaItemMap.entrySet()) {
            master = entry.getKey();
            item = (FormulaItem)entry.getValue();
            if (item.getInbound() != null) {
                for (ItemReference input : item.getInbound().getInputs()) {
                    input.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)input.getItem()));
                }
            }
            if (item.getOutbound() == null) continue;
            TypedItemReference output = item.getOutbound().getOutput();
            output.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)output.getItem()));
        }
    }
}

