/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.configuration.component.ChangeCounter;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.BufferedValue;
import org.eclipse.scada.configuration.world.osgi.ChangeCounterItem;
import org.eclipse.scada.configuration.world.osgi.DataType;

public class ChangeCounterGenerator
extends DataComponentGenerator {
    private final ChangeCounter changeCounter;
    private final Map<String, ChangeCounterItem> mapping = new HashMap<String, ChangeCounterItem>();

    public ChangeCounterGenerator(ChangeCounter changeCounter) {
        super((DataComponent)changeCounter);
        this.changeCounter = changeCounter;
    }

    @Override
    public void createItems(ItemCreator itemCreator) {
        CreationRequest request = itemCreator.createChangeCounterItem(this.changeCounter.getType(), this.changeCounter.getOnError(), (List)this.changeCounter.getValues());
        request.localTags(new String[]{this.changeCounter.getName()});
        request.customizationTags((Collection)this.changeCounter.getCustomizationTags());
        request.dataType(DataType.INT64);
        request.information(this.changeCounter.getShortDescription(), null, null);
        this.mapping.put(this.changeCounter.getBuffer().getName(), (ChangeCounterItem)request.create());
    }

    @Override
    protected void finishForMaster(FinishContext context, GeneratorContext.MasterContext master) {
        for (Map.Entry<String, ChangeCounterItem> entry : this.mapping.entrySet()) {
            for (BufferedValue bufferedValue : master.getImplementation().getBufferedValues()) {
                if (!entry.getKey().equals(bufferedValue.getName())) continue;
                entry.getValue().setBuffer(bufferedValue);
            }
        }
        super.finishForMaster(context, master);
    }
}

