/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.infrastructure.ApplicationConfiguration;
import org.eclipse.scada.configuration.infrastructure.CommonDriver;
import org.eclipse.scada.configuration.infrastructure.Configurations;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.EventInjectorHttp;
import org.eclipse.scada.configuration.infrastructure.EventInjectorSyslog;
import org.eclipse.scada.configuration.infrastructure.ExternalDriver;
import org.eclipse.scada.configuration.infrastructure.ExternalDriverPlaceholder;
import org.eclipse.scada.configuration.infrastructure.ExternalNode;
import org.eclipse.scada.configuration.infrastructure.GenericVMSettings;
import org.eclipse.scada.configuration.infrastructure.HttpServiceModule;
import org.eclipse.scada.configuration.infrastructure.InfrastructureFactory;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.JdbcUserService;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.Options;
import org.eclipse.scada.configuration.infrastructure.OracleVMSettings;
import org.eclipse.scada.configuration.infrastructure.RestExporterModule;
import org.eclipse.scada.configuration.infrastructure.SlaveStorageLayout;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.SystemPropertyUserService;
import org.eclipse.scada.configuration.infrastructure.UserEntry;
import org.eclipse.scada.configuration.infrastructure.ValueArchiveServer;
import org.eclipse.scada.configuration.infrastructure.ValueArchiveSlave;
import org.eclipse.scada.configuration.infrastructure.WebAdminConsole;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.impl.ApplicationConfigurationImpl;
import org.eclipse.scada.configuration.infrastructure.impl.CommonDriverImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ConfigurationsImpl;
import org.eclipse.scada.configuration.infrastructure.impl.EquinoxDriverImpl;
import org.eclipse.scada.configuration.infrastructure.impl.EventInjectorHttpImpl;
import org.eclipse.scada.configuration.infrastructure.impl.EventInjectorSyslogImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ExternalDriverImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ExternalDriverPlaceholderImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ExternalNodeImpl;
import org.eclipse.scada.configuration.infrastructure.impl.GenericVMSettingsImpl;
import org.eclipse.scada.configuration.infrastructure.impl.HttpServiceModuleImpl;
import org.eclipse.scada.configuration.infrastructure.impl.JdbcUserServiceImpl;
import org.eclipse.scada.configuration.infrastructure.impl.MasterImportImpl;
import org.eclipse.scada.configuration.infrastructure.impl.MasterServerImpl;
import org.eclipse.scada.configuration.infrastructure.impl.OptionsImpl;
import org.eclipse.scada.configuration.infrastructure.impl.OracleVMSettingsImpl;
import org.eclipse.scada.configuration.infrastructure.impl.RestExporterModuleImpl;
import org.eclipse.scada.configuration.infrastructure.impl.SystemNodeImpl;
import org.eclipse.scada.configuration.infrastructure.impl.SystemPropertyUserServiceImpl;
import org.eclipse.scada.configuration.infrastructure.impl.UserEntryImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ValueArchiveServerImpl;
import org.eclipse.scada.configuration.infrastructure.impl.ValueArchiveSlaveImpl;
import org.eclipse.scada.configuration.infrastructure.impl.WebAdminConsoleImpl;
import org.eclipse.scada.configuration.infrastructure.impl.WorldImpl;

public class InfrastructureFactoryImpl
extends EFactoryImpl
implements InfrastructureFactory {
    public static InfrastructureFactory init() {
        try {
            InfrastructureFactory theInfrastructureFactory = (InfrastructureFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/Infrastructure");
            if (theInfrastructureFactory != null) {
                return theInfrastructureFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InfrastructureFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createWorld();
            }
            case 2: {
                return this.createMasterServer();
            }
            case 3: {
                return this.createMasterImport();
            }
            case 4: {
                return this.createOptions();
            }
            case 6: {
                return this.createCommonDriver();
            }
            case 7: {
                return this.createExternalNode();
            }
            case 8: {
                return this.createSystemNode();
            }
            case 9: {
                return this.createSystemPropertyUserService();
            }
            case 10: {
                return this.createUserEntry();
            }
            case 12: {
                return this.createJdbcUserService();
            }
            case 13: {
                return this.createValueArchiveServer();
            }
            case 16: {
                return this.createEquinoxDriver();
            }
            case 17: {
                return this.createExternalDriver();
            }
            case 19: {
                return this.createExternalDriverPlaceholder();
            }
            case 20: {
                return this.createApplicationConfiguration();
            }
            case 21: {
                return this.createConfigurations();
            }
            case 23: {
                return this.createHttpServiceModule();
            }
            case 24: {
                return this.createRestExporterModule();
            }
            case 25: {
                return this.createValueArchiveSlave();
            }
            case 26: {
                return this.createWebAdminConsole();
            }
            case 27: {
                return this.createOracleVMSettings();
            }
            case 28: {
                return this.createGenericVMSettings();
            }
            case 32: {
                return this.createEventInjectorHttp();
            }
            case 33: {
                return this.createEventInjectorSyslog();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.createSlaveStorageLayoutFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.convertSlaveStorageLayoutToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public World createWorld() {
        WorldImpl world = new WorldImpl();
        world.setConfigurations(InfrastructureFactory.eINSTANCE.createConfigurations());
        return world;
    }

    @Override
    public MasterServer createMasterServer() {
        MasterServerImpl masterServer = new MasterServerImpl();
        masterServer.setName("master");
        masterServer.setInstanceNumber(1);
        return masterServer;
    }

    @Override
    public MasterImport createMasterImport() {
        MasterImportImpl masterImport = new MasterImportImpl();
        return masterImport;
    }

    @Override
    public Options createOptions() {
        OptionsImpl options = new OptionsImpl();
        return options;
    }

    @Override
    public CommonDriver createCommonDriver() {
        CommonDriverImpl commonDriver = new CommonDriverImpl();
        return commonDriver;
    }

    @Override
    public ExternalNode createExternalNode() {
        ExternalNodeImpl externalNode = new ExternalNodeImpl();
        return externalNode;
    }

    @Override
    public SystemNode createSystemNode() {
        SystemNodeImpl systemNode = new SystemNodeImpl();
        return systemNode;
    }

    @Override
    public SystemPropertyUserService createSystemPropertyUserService() {
        SystemPropertyUserServiceImpl systemPropertyUserService = new SystemPropertyUserServiceImpl();
        return systemPropertyUserService;
    }

    @Override
    public UserEntry createUserEntry() {
        UserEntryImpl userEntry = new UserEntryImpl();
        return userEntry;
    }

    @Override
    public JdbcUserService createJdbcUserService() {
        JdbcUserServiceImpl jdbcUserService = new JdbcUserServiceImpl();
        return jdbcUserService;
    }

    @Override
    public ValueArchiveServer createValueArchiveServer() {
        ValueArchiveServerImpl valueArchiveServer = new ValueArchiveServerImpl();
        valueArchiveServer.setName("hdserver");
        valueArchiveServer.setInstanceNumber(2);
        return valueArchiveServer;
    }

    @Override
    public EquinoxDriver createEquinoxDriver() {
        EquinoxDriverImpl equinoxDriver = new EquinoxDriverImpl();
        return equinoxDriver;
    }

    @Override
    public ExternalDriver createExternalDriver() {
        ExternalDriverImpl externalDriver = new ExternalDriverImpl();
        return externalDriver;
    }

    @Override
    public ExternalDriverPlaceholder createExternalDriverPlaceholder() {
        ExternalDriverPlaceholderImpl externalDriverPlaceholder = new ExternalDriverPlaceholderImpl();
        return externalDriverPlaceholder;
    }

    @Override
    public ApplicationConfiguration createApplicationConfiguration() {
        ApplicationConfigurationImpl applicationConfiguration = new ApplicationConfigurationImpl();
        return applicationConfiguration;
    }

    @Override
    public Configurations createConfigurations() {
        ConfigurationsImpl configurations = new ConfigurationsImpl();
        return configurations;
    }

    @Override
    public HttpServiceModule createHttpServiceModule() {
        HttpServiceModuleImpl httpServiceModule = new HttpServiceModuleImpl();
        return httpServiceModule;
    }

    @Override
    public RestExporterModule createRestExporterModule() {
        RestExporterModuleImpl restExporterModule = new RestExporterModuleImpl();
        return restExporterModule;
    }

    @Override
    public ValueArchiveSlave createValueArchiveSlave() {
        ValueArchiveSlaveImpl valueArchiveSlave = new ValueArchiveSlaveImpl();
        valueArchiveSlave.setName("hdslave");
        valueArchiveSlave.setInstanceNumber(3);
        return valueArchiveSlave;
    }

    @Override
    public WebAdminConsole createWebAdminConsole() {
        WebAdminConsoleImpl webAdminConsole = new WebAdminConsoleImpl();
        return webAdminConsole;
    }

    @Override
    public OracleVMSettings createOracleVMSettings() {
        OracleVMSettingsImpl oracleVMSettings = new OracleVMSettingsImpl();
        return oracleVMSettings;
    }

    @Override
    public GenericVMSettings createGenericVMSettings() {
        GenericVMSettingsImpl genericVMSettings = new GenericVMSettingsImpl();
        return genericVMSettings;
    }

    @Override
    public EventInjectorHttp createEventInjectorHttp() {
        EventInjectorHttpImpl eventInjectorHttp = new EventInjectorHttpImpl();
        return eventInjectorHttp;
    }

    @Override
    public EventInjectorSyslog createEventInjectorSyslog() {
        EventInjectorSyslogImpl eventInjectorSyslog = new EventInjectorSyslogImpl();
        return eventInjectorSyslog;
    }

    public SlaveStorageLayout createSlaveStorageLayoutFromString(EDataType eDataType, String initialValue) {
        SlaveStorageLayout result = SlaveStorageLayout.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSlaveStorageLayoutToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public InfrastructurePackage getInfrastructurePackage() {
        return (InfrastructurePackage)this.getEPackage();
    }

    @Deprecated
    public static InfrastructurePackage getPackage() {
        return InfrastructurePackage.eINSTANCE;
    }
}

