/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;

public abstract class CommonPackageDeploymentContext
implements DeploymentContext {
    private final Set<String> dependencies = new HashSet<String>();
    protected final StringBuilder postInstallation = new StringBuilder();
    protected final StringBuilder preInstallation = new StringBuilder();
    protected final StringBuilder postRemoval = new StringBuilder();
    protected final StringBuilder preRemoval = new StringBuilder();
    private final String packageName;

    public CommonPackageDeploymentContext(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void addInstallDependency(String packageName) {
        this.dependencies.add(packageName);
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public String getPostInstallationString() {
        return this.postInstallation.toString();
    }

    public String getPreInstallationString() {
        return this.preInstallation.toString();
    }

    public String getPostRemovalString() {
        return this.postRemoval.toString();
    }

    public String getPreRemovalString() {
        return this.preRemoval.toString();
    }

    @Override
    public void addPostInstallationScript(Reader reader) throws IOException {
        try {
            CharStreams.copy((Readable)reader, (Appendable)this.postInstallation);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void addPreInstallationScript(Reader reader) throws IOException {
        try {
            CharStreams.copy((Readable)reader, (Appendable)this.preInstallation);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void addPostRemovalScript(Reader reader) throws IOException {
        try {
            CharStreams.copy((Readable)reader, (Appendable)this.postRemoval);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void addPreRemovalScript(Reader reader) throws IOException {
        try {
            CharStreams.copy((Readable)reader, (Appendable)this.preRemoval);
        }
        finally {
            reader.close();
        }
    }
}

