/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.world.deployment.Mappings;
import org.eclipse.scada.configuration.world.lib.deployment.AbstractMapper;

public class MappingHandler
extends AbstractMapper {
    @Inject
    private EObject model;
    @Inject
    private Mappings mappings;
    @Inject
    private String targets;
    private Map<String, Set<String>> parsedMappings = new HashMap<String, Set<String>>();

    @Override
    protected Mappings getMappings() {
        return this.mappings;
    }

    public void execute(IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Mapping elements");
        this.parsedMappings = this.parse();
        TreeIterator i = this.model.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            String className = o.eClass().getName();
            Set<String> features = this.parsedMappings.get(className);
            if (features == null) continue;
            for (String f : features) {
                EStructuralFeature sf = o.eClass().getEStructuralFeature(f);
                if (sf == null) {
                    throw new RuntimeException(String.format("Class %s does not have feature %s", className, f));
                }
                this.replaceName(o, sf);
            }
        }
    }

    private Map<String, Set<String>> parse() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (this.targets == null || this.targets.isEmpty()) {
            return result;
        }
        String[] stringArray = this.targets.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            String[] a = tok.split(":", 2);
            result.put(a[0], new HashSet<String>(Arrays.asList(a[1].split(","))));
            ++n2;
        }
        return result;
    }
}

