/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.Configurations;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EventPool;
import org.eclipse.scada.configuration.world.osgi.ExternalEventFilter;
import org.eclipse.scada.configuration.world.osgi.ExternalEventMonitor;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.MonitorPool;
import org.eclipse.scada.configuration.world.osgi.SimpleExternalEventFilter;
import org.eclipse.scada.configuration.world.osgi.StaticExternalEventFilter;

public class AlarmsAndEventsProcessor
extends BasicOscarProcessor {
    private final MasterServer app;

    public AlarmsAndEventsProcessor(MasterServer app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        this.createServerInformation();
        for (MonitorPool pool : this.app.getMonitorPools()) {
            this.createMonitorPool(pool);
        }
        for (MonitorPool pool : this.app.getEventPools()) {
            this.createEventPool((EventPool)pool);
        }
        for (ExternalEventMonitor eventMonitor : this.app.getExternalEventMonitors()) {
            this.createExternalEventMonitor(eventMonitor);
        }
        this.createExternalFilters();
    }

    private void createExternalFilters() {
        int priority = 100;
        for (ExternalEventFilter filter : this.app.getExternalEventFilters()) {
            this.createFilter(filter, priority);
            priority += 100;
        }
    }

    private void createFilter(ExternalEventFilter filter, int priority) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("priority", "" + priority);
        data.put("id", Names.makeName((NamedDocumentable)filter));
        if (filter instanceof SimpleExternalEventFilter) {
            data.put("type", "filter");
            data.put("filter", ((SimpleExternalEventFilter)filter).getFilter());
            this.addData("org.eclipse.scada.ae.server.http.eventFilter", Names.makeName((NamedDocumentable)filter), data);
        } else if (filter instanceof StaticExternalEventFilter) {
            data.put("type", "static");
            data.put("value", ((StaticExternalEventFilter)filter).getValue());
            this.addData("org.eclipse.scada.ae.server.http.eventFilter", Names.makeName((NamedDocumentable)filter), data);
        }
    }

    private void createExternalEventMonitor(ExternalEventMonitor eventMonitor) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filter", eventMonitor.getFilter());
        Configurations.applyInfoAttributes(Properties.makeAttributes((Collection)eventMonitor.getProperties()), data);
        this.addData("ae.monitor.ae.event.external", Names.makeName((NamedDocumentable)eventMonitor), data);
    }

    private void createEventPool(EventPool pool) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filter", pool.getFilter());
        data.put("size", "" + pool.getSize());
        this.addData("org.eclipse.scada.ae.server.common.event.pool", Names.makeName((NamedDocumentable)pool), data);
    }

    private void createMonitorPool(MonitorPool pool) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filter", pool.getFilter());
        this.addData("ae.monitor.query", Names.makeName((NamedDocumentable)pool), data);
    }

    private void createServerInformation() {
        String prefix = this.app.getAeServerInformationPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("prefix", prefix);
            this.addData("ae.server.info", prefix, data);
        }
    }
}

