/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.Average;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.MovingAverage;
import org.eclipse.scada.utils.str.StringHelper;

public class AverageProcessor
extends BasicOscarProcessor {
    private final MasterServer app;

    public AverageProcessor(MasterServer app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        for (Average average : this.app.getAverages()) {
            this.createAverage(average);
        }
        for (Average average : this.app.getMovingAverages()) {
            this.createMovingAverage((MovingAverage)average);
        }
    }

    private void createMovingAverage(MovingAverage average) {
        String id = Names.makeName((NamedDocumentable)average);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("datasource.id", Items.makeMasterId(average.getItem()));
        data.put("trigger", "" + average.getTrigger());
        if (average.getTriggerOnly() != null) {
            data.put("triggerOnly", "" + average.getTriggerOnly());
        }
        data.put("nullRange", "" + average.getNullRange());
        data.put("range", "" + average.getRange());
        this.addData("org.eclipse.scada.da.datasource.movingaverage", id, data);
    }

    private void createAverage(Average average) {
        String id = Names.makeName((NamedDocumentable)average);
        HashMap<String, String> data = new HashMap<String, String>();
        if (average.getSourcesRequired() != null) {
            data.put("validSourcesRequired", average.getSourcesRequired());
        } else {
            data.put("validSourcesRequired", "0");
        }
        ArrayList<String> sources = new ArrayList<String>(average.getItems().size());
        for (Item item : average.getItems()) {
            sources.add(Items.makeMasterId(item));
        }
        Collections.sort(sources);
        data.put("sources", StringHelper.join(sources, (String)", "));
        this.addData("org.eclipse.scada.da.datasource.average", id, data);
    }
}

