/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicTypedOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.JdbcUserService;
import org.eclipse.scada.configuration.world.osgi.JdbcUserServiceModule;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;

public class JdbcUserServiceModuleProcessor
extends BasicTypedOscarProcessor<JdbcUserServiceModule> {
    private final EquinoxApplication app;

    public JdbcUserServiceModuleProcessor(EquinoxApplication app, OscarContext ctx) {
        super(app, ctx, JdbcUserServiceModule.class);
        this.app = app;
    }

    @Override
    protected void process(JdbcUserServiceModule module) {
        Profile profile = Profiles.createOrGetCustomizationProfile((EquinoxApplication)this.app);
        Profiles.addStartBundle((Profile)profile, (String)"org.eclipse.scada.sec.provider.jdbc");
        for (JdbcUserService service : module.getUserServices()) {
            this.createService(service);
        }
    }

    private void createService(JdbcUserService service) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("driver", service.getJdbcDriver());
        data.put("passwordType", service.getPasswordType().toString());
        data.put("findUserSql", service.getFindUserSql());
        Helper.addOptional(data, "findRolesForUserSql", service.getFindRolesForUserSql());
        Helper.addOptional(data, "userIdColumnName", service.getUserIdColumnName());
        Helper.addOptional(data, "passwordColumnName", service.getPasswordColumnName());
        Helper.addOptional(data, "updatePasswordSql", service.getUpdatePasswordSql());
        data.put("authoritative", service.isAuthorative() ? "true" : "false ");
        data.putAll(Properties.makeAttributes((String)"jdbc.properties.", (Collection)service.getJdbcPropeties()));
        this.addData("org.eclipse.scada.sec.provider.jdbc.authenticator", Names.makeName((NamedDocumentable)service), data);
    }
}

