/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OscarContext {
    private final Map<String, Map<String, Map<String, String>>> data = new HashMap<String, Map<String, Map<String, String>>>();
    private final Map<String, Set<String>> ignoreFields = new HashMap<String, Set<String>>();

    public void addIgnoreField(String factoryId, String fieldName) {
        Set<String> fields = this.ignoreFields.get(factoryId);
        if (fields == null) {
            fields = new HashSet<String>();
            this.ignoreFields.put(factoryId, fields);
        }
        fields.add(fieldName);
    }

    public void addIgnoreFields(String factoryId, String ... fieldNames) {
        Set<String> fields = this.ignoreFields.get(factoryId);
        if (fields == null) {
            fields = new HashSet<String>();
            this.ignoreFields.put(factoryId, fields);
        }
        fields.addAll(Arrays.asList(fieldNames));
    }

    public void addData(String factoryId, String configurationId, Map<String, String> data) {
        Map<String, Map<String, String>> factoryData = this.data.get(factoryId);
        if (factoryData == null) {
            factoryData = new HashMap<String, Map<String, String>>();
            this.data.put(factoryId, factoryData);
        }
        factoryData.put(configurationId, data);
    }

    public Map<String, Map<String, Map<String, String>>> getData() {
        return this.data;
    }

    public Map<String, Set<String>> getIgnoreFields() {
        return this.ignoreFields;
    }
}

