/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.lib.oscar.Configurations;
import org.eclipse.scada.configuration.world.osgi.Item;

public final class Items {
    private static final String delimiter = ".";

    private Items() {
    }

    public static String makeId(Item item, String tag) {
        return String.valueOf(item.getName()) + delimiter + tag;
    }

    public static String makeMasterId(Item item) {
        return Items.makeId(item, "master");
    }

    private static void addAttribute(Map<String, String> attributes, String key, String value) {
        if (value != null) {
            attributes.put(key, value);
        }
    }

    public static Map<String, String> createInfoAttributes(Item item) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Configurations.fillAttributesWithHierarchy(attributes, Names.makeHierarchy((Item)item));
        attributes.put("item", item.getName());
        if (item.getInformation() != null) {
            Items.addAttribute(attributes, "system", item.getInformation().getSystem());
            Items.addAttribute(attributes, "unit", item.getInformation().getUnit());
            Items.addAttribute(attributes, "itemDescription", item.getInformation().getDescription());
        }
        return attributes;
    }

    public static void fillForMasterHandler(Map<String, String> data, Item item, int priority) {
        Items.fillForMasterHandler(data, item, priority, true);
    }

    public static void fillForMasterHandler(Map<String, String> data, Item item, int priority, boolean infoAttributes) {
        if (infoAttributes) {
            Configurations.applyInfoAttributes(Items.createInfoAttributes(item), data);
        }
        data.put("master.id", Items.makeMasterId(item));
        data.put("handlerPriority", "" + priority);
    }
}

