/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.sec;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.security.Rule;
import org.eclipse.scada.configuration.security.Rules;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.sec.RuleEncoder;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public class SecurityProcessor
extends BasicOscarProcessor {
    private final EquinoxApplication app;

    public SecurityProcessor(EquinoxApplication app, OscarContext oscarContext) {
        super((NamedDocumentable)app, oscarContext);
        this.app = app;
    }

    public void process(IProgressMonitor monitor) {
        this.addSecurityRules((Rules)this.app.getSecurityConfiguration(), monitor);
    }

    public void addSecurityRules(Rules rules, IProgressMonitor monitor) {
        if (rules == null) {
            return;
        }
        int priority = 1000;
        monitor.beginTask("Encoding security rules", rules.getRules().size());
        for (Rule rule : Lists.reverse((List)rules.getRules())) {
            RuleEncoder encoder = RuleEncoder.findEncoder(rule);
            if (encoder != null) {
                encoder.encodeRule(this.ctx, priority += 100);
            }
            monitor.worked(1);
        }
        monitor.done();
    }
}

