/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.sec;

import java.util.Map;
import org.eclipse.scada.configuration.security.CA;
import org.eclipse.scada.configuration.security.Rule;
import org.eclipse.scada.configuration.security.SignatureRule;
import org.eclipse.scada.configuration.world.lib.oscar.sec.RuleEncoder;

public class SigatureRuleEncoder
extends RuleEncoder {
    private final SignatureRule rule;

    public SigatureRuleEncoder(SignatureRule rule) {
        super((Rule)rule);
        this.rule = rule;
    }

    @Override
    protected void putData(Map<String, String> data) {
        super.putData(data);
        data.put("properties.reloadPeriod", "" + this.rule.getReloadPeriod());
        int i = 0;
        for (CA ca : this.rule.getTrustedCertificationAuthority()) {
            if (ca.getCertificateUrl() != null) {
                data.put(String.format("properties.ca.%s.cert", i), ca.getCertificateUrl());
            }
            int j = 0;
            for (String url : ca.getCrlUrl()) {
                data.put(String.format("properties.ca.%s.crl.%s", i, j), url);
                ++j;
            }
            ++i;
        }
        SigatureRuleEncoder.putScript(data, "properties.postProcessor", this.rule.getPostProcessor());
    }
}

