/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.client.net.SessionConnectionBase;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.da.client.BrowseOperationCallback;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.WriteAttributeOperationCallback;
import org.eclipse.scada.da.client.WriteOperationCallback;
import org.eclipse.scada.da.client.net.DriverFactory;
import org.eclipse.scada.da.client.net.operations.BrowseOperationController;
import org.eclipse.scada.da.client.net.operations.WriteAttributesOperationController;
import org.eclipse.scada.da.client.net.operations.WriteOperationController;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.net.handler.ListBrowser;
import org.eclipse.scada.da.net.handler.Messages;
import org.eclipse.scada.da.net.handler.WriteAttributesOperation;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.exec.LongRunningListener;
import org.eclipse.scada.utils.exec.LongRunningOperation;
import org.eclipse.scada.utils.exec.LongRunningState;
import org.eclipse.scada.utils.lang.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends SessionConnectionBase
implements org.eclipse.scada.da.client.Connection {
    public static final String VERSION = "0.1.8";
    private static final Logger logger;
    private final Map<String, ItemUpdateListener> itemListeners = new ConcurrentHashMap<String, ItemUpdateListener>();
    private final Map<Location, FolderListener> folderListeners = new ConcurrentHashMap<Location, FolderListener>();
    private final BrowseOperationController browseController;
    private final WriteOperationController writeController;
    private final WriteAttributesOperationController writeAttributesController;

    static {
        DriverFactory.registerDriver();
        logger = LoggerFactory.getLogger(Connection.class);
    }

    public String getRequiredVersion() {
        return VERSION;
    }

    public Connection(ConnectionInformation connectionInformantion) {
        super(connectionInformantion);
        this.messenger.setHandler(65568, new MessageListener(){

            public void messageReceived(Message message) {
                Connection.this.notifyDataChange(message);
            }
        });
        this.messenger.setHandler(66064, new MessageListener(){

            public void messageReceived(Message message) {
                logger.debug("Browse event message from server");
                Connection.this.performBrowseEvent(message);
            }
        });
        this.messenger.setHandler(65570, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                logger.debug("received subscription change");
                Connection.this.performSubscriptionChange(message);
            }
        });
        this.browseController = new BrowseOperationController(this.messenger);
        this.browseController.register();
        this.writeController = new WriteOperationController(this.messenger);
        this.writeController.register();
        this.writeAttributesController = new WriteAttributesOperationController(this.messenger);
        this.writeAttributesController.register();
    }

    private void fireBrowseEvent(Location location, final Collection<Entry> added, final Collection<String> removed, final boolean full) {
        final FolderListener listener = this.folderListeners.get(location);
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.folderChanged(added, removed, full);
                }
            });
        }
    }

    private void fireDataChange(String itemName, final Variant value, final Map<String, Variant> attributes, final boolean cache) {
        final ItemUpdateListener listener = this.itemListeners.get(itemName);
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifyDataChange(value, attributes, cache);
                }
            });
        }
    }

    private void notifyDataChange(Message message) {
        boolean cache = message.getValues().containsKey("cache-read");
        String itemId = message.getValues().get("item-id").toString();
        Variant value = this.decodeValueChange(message);
        Map<String, Variant> attributes = this.decodeAttributeChange(message);
        if (cache && value == null) {
            value = Variant.NULL;
        }
        if (cache && attributes == null) {
            attributes = new HashMap<String, Variant>(0);
        }
        this.fireDataChange(itemId, value, attributes, cache);
    }

    private Variant decodeValueChange(Message message) {
        if (message.getValues().containsKey("value")) {
            return MessageHelper.valueToVariant((Value)message.getValues().get("value"), null);
        }
        return null;
    }

    private Map<String, Variant> decodeAttributeChange(Message message) {
        Value unsetEntries;
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Value setEntries = message.getValues().get("attributes-set");
        if (setEntries instanceof MapValue) {
            for (Map.Entry entry : ((MapValue)setEntries).getValues().entrySet()) {
                Variant variant = MessageHelper.valueToVariant((Value)((Value)entry.getValue()), null);
                if (variant == null) continue;
                attributes.put((String)entry.getKey(), variant);
            }
        }
        if ((unsetEntries = message.getValues().get("attributes-unset")) instanceof ListValue) {
            for (Value entry : ((ListValue)unsetEntries).getValues()) {
                if (!(entry instanceof StringValue)) continue;
                attributes.put(((StringValue)entry).getValue(), null);
            }
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    private void performBrowseEvent(Message message) {
        logger.debug("Performing browse event");
        ArrayList<Entry> added = new ArrayList<Entry>();
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList path = new ArrayList();
        Holder initial = new Holder();
        initial.value = false;
        ListBrowser.parseEvent((Message)message, path, added, removed, (Holder)initial);
        Location location = new Location(path);
        logger.debug("Folder: {} - Added: {} - Removed: {}", new Object[]{location, added.size(), removed.size()});
        this.fireBrowseEvent(location, added, removed, (Boolean)initial.value);
    }

    public NotifyFuture<WriteResult> startWrite(String itemId, Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        WriteOperationFuture callback = new WriteOperationFuture();
        this.write(itemId, value, operationParameters, callback);
        return callback;
    }

    public void write(String item, Variant value, OperationParameters operationParameters, final WriteOperationCallback callback) {
        block2: {
            try {
                this.writeController.start(item, value, operationParameters, new LongRunningListener(){

                    public void stateChanged(LongRunningOperation operation, LongRunningState state, Throwable error) {
                        switch (state) {
                            case FAILURE: {
                                if (callback == null) break;
                                callback.failed(error != null ? error.getMessage() : "<unknown error>");
                                break;
                            }
                            case SUCCESS: {
                                try {
                                    Connection.this.completeWrite(operation);
                                    if (callback == null) break;
                                    callback.complete();
                                }
                                catch (OperationException e) {
                                    logger.debug("Failed to write", (Throwable)e);
                                    if (callback == null) break;
                                    callback.failed(e.getMessage());
                                }
                                break;
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.info("Failed to write", (Throwable)e);
                if (callback == null) break block2;
                callback.error((Throwable)e);
            }
        }
    }

    protected void completeWrite(LongRunningOperation operation) throws OperationException {
        Message reply;
        if (!(operation instanceof org.eclipse.scada.net.base.LongRunningOperation)) {
            throw new RuntimeException("Operation is not of type org.eclipse.scada.net.base.LongRunningOperation");
        }
        org.eclipse.scada.net.base.LongRunningOperation op = (org.eclipse.scada.net.base.LongRunningOperation)operation;
        if (op.getError() != null) {
            throw new OperationException(op.getError());
        }
        if (op.getReply() != null && (reply = op.getReply()).getValues().containsKey("error-info")) {
            throw new OperationException(reply.getValues().get("error-info").toString());
        }
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        WriteAttributeOperationFuture callback = new WriteAttributeOperationFuture();
        this.writeAttributes(itemId, attributes, operationParameters, callback);
        return callback;
    }

    public void writeAttributes(String item, Map<String, Variant> attributes, OperationParameters operationParameters, final WriteAttributeOperationCallback callback) {
        try {
            this.writeAttributesController.start(item, attributes, operationParameters, new LongRunningListener(){

                public void stateChanged(LongRunningOperation operation, LongRunningState state, Throwable error) {
                    switch (state) {
                        case FAILURE: {
                            if (callback == null) break;
                            callback.failed(error.getMessage());
                            break;
                        }
                        case SUCCESS: {
                            try {
                                WriteAttributeResults results = Connection.this.completeWriteAttributes(operation);
                                if (callback == null) break;
                                callback.complete(results);
                            }
                            catch (OperationException e) {
                                logger.debug("Failed to write attributes", (Throwable)e);
                                if (callback == null) break;
                                callback.failed(e.getMessage());
                            }
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to perform write", (Throwable)e);
            callback.error((Throwable)e);
        }
    }

    public WriteAttributeResults completeWriteAttributes(LongRunningOperation operation) throws OperationException {
        if (!(operation instanceof org.eclipse.scada.net.base.LongRunningOperation)) {
            throw new RuntimeException("Operation is not of type org.eclipse.scada.net.base.LongRunningOperation");
        }
        org.eclipse.scada.net.base.LongRunningOperation op = (org.eclipse.scada.net.base.LongRunningOperation)operation;
        if (op.getError() != null) {
            throw new OperationException(op.getError());
        }
        if (op.getReply() != null) {
            Message reply = op.getReply();
            try {
                return WriteAttributesOperation.parseResponse((Message)reply);
            }
            catch (Exception e) {
                throw new OperationException((Throwable)e);
            }
        }
        return null;
    }

    protected Entry[] completeBrowse(LongRunningOperation operation) throws OperationException {
        if (!(operation instanceof org.eclipse.scada.net.base.LongRunningOperation)) {
            throw new RuntimeException("Operation is not of type org.eclipse.scada.net.base.LongRunningOperation");
        }
        org.eclipse.scada.net.base.LongRunningOperation op = (org.eclipse.scada.net.base.LongRunningOperation)operation;
        if (op.getError() != null) {
            throw new OperationException(op.getError());
        }
        if (op.getReply() != null) {
            Message reply = op.getReply();
            if (reply.getValues().containsKey("error-info")) {
                throw new OperationException(reply.getValues().get("error-info").toString());
            }
            try {
                return ListBrowser.parseResponse((Message)reply);
            }
            catch (Exception e) {
                logger.info("Failed to complete browse", (Throwable)e);
                throw new OperationException((Throwable)e);
            }
        }
        return null;
    }

    public void subscribeItem(String itemId) throws NoConnectionException {
        logger.debug("Subscribe to item: {}", (Object)itemId);
        if (this.getState() == ConnectionState.BOUND) {
            this.messenger.sendMessage(Messages.subscribeItem((String)itemId));
        }
    }

    public void unsubscribeItem(String itemId) throws NoConnectionException {
        logger.debug("Unsubscribe from item: {}", (Object)itemId);
        if (this.getState() == ConnectionState.BOUND) {
            this.messenger.sendMessage(Messages.unsubscribeItem((String)itemId));
        }
    }

    public ItemUpdateListener setItemUpdateListener(String itemId, ItemUpdateListener listener) {
        return this.itemListeners.put(itemId, listener);
    }

    public FolderListener setFolderListener(Location location, FolderListener listener) {
        return this.folderListeners.put(location, listener);
    }

    public void subscribeFolder(Location location) throws NoConnectionException, OperationException {
        logger.debug("Subscribe to folder: {}", (Object)location);
        this.messenger.sendMessage(ListBrowser.createSubscribe((String[])location.asArray()));
    }

    public void unsubscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.messenger.sendMessage(ListBrowser.createUnsubscribe((String[])location.asArray()));
    }

    protected synchronized void onConnectionClosed() {
        final HashMap<Location, FolderListener> listeners = new HashMap<Location, FolderListener>(this.folderListeners);
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : listeners.entrySet()) {
                    ((FolderListener)entry.getValue()).folderChanged(Collections.emptyList(), Collections.emptyList(), true);
                }
            }
        });
        super.onConnectionClosed();
    }

    protected void performSubscriptionChange(Message message) {
        Holder item = new Holder();
        Holder subscriptionState = new Holder();
        Messages.parseSubscriptionChange((Message)message, (Holder)item, (Holder)subscriptionState);
        this.fireSubscriptionChange((String)item.value, (SubscriptionState)subscriptionState.value);
    }

    private void fireSubscriptionChange(String item, final SubscriptionState subscriptionState) {
        final ItemUpdateListener listener = this.itemListeners.get(item);
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(subscriptionState, null);
                }
            });
        }
    }

    public Entry[] browse(Location location, int timeout) throws NoConnectionException, OperationException {
        LongRunningOperation op = this.browseController.start(location.asArray(), null);
        try {
            op.waitForCompletion(timeout);
            return this.completeBrowse(op);
        }
        catch (InterruptedException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void browse(Location location, final BrowseOperationCallback callback) {
        try {
            this.browseController.start(location.asArray(), new LongRunningListener(){

                public void stateChanged(LongRunningOperation operation, LongRunningState state, Throwable error) {
                    switch (state) {
                        case FAILURE: {
                            if (callback == null) break;
                            callback.failed(error.getMessage());
                            break;
                        }
                        case SUCCESS: {
                            try {
                                Entry[] result = Connection.this.completeBrowse(operation);
                                if (callback == null) break;
                                callback.complete(result);
                            }
                            catch (OperationException e) {
                                logger.debug("Failed to browse", (Throwable)e);
                                if (callback == null) break;
                                callback.failed(e.getMessage());
                            }
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.info("Failed to start browsing", (Throwable)e);
            callback.error((Throwable)e);
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public static final class WriteAttributeOperationFuture
    extends AbstractFuture<WriteAttributeResults>
    implements WriteAttributeOperationCallback {
        public void failed(String error) {
            this.setError(new OperationException(error));
        }

        public void error(Throwable e) {
            this.setError(e);
        }

        public void complete(WriteAttributeResults result) {
            this.setResult(result);
        }
    }

    public static final class WriteOperationFuture
    extends AbstractFuture<WriteResult>
    implements WriteOperationCallback {
        public void failed(String error) {
            this.setError(new OperationException(error));
        }

        public void error(Throwable e) {
            this.setError(e);
        }

        public void complete() {
            this.setResult(null);
        }
    }
}

