/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.script;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.script.ScriptSourceFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private ScheduledExecutorService executor;
    private ScriptSourceFactory factory;
    private EventProcessor eventProcessor;

    public void start(BundleContext context) throws Exception {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.eventProcessor = new EventProcessor(context);
        this.eventProcessor.open();
        this.factory = new ScriptSourceFactory(context, this.executor, this.eventProcessor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "A scripting data source");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.factory.dispose();
        this.executor.shutdown();
        this.eventProcessor.close();
    }
}

