/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.script;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.script.ScriptDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptSourceFactory
extends AbstractServiceConfigurationFactory<ScriptDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(ScriptSourceFactory.class);
    private final ScheduledExecutorService executor;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;
    private final EventProcessor eventProcessor;

    public ScriptSourceFactory(BundleContext context, ScheduledExecutorService executor, EventProcessor eventProcessor) throws InvalidSyntaxException {
        super(context);
        this.executor = executor;
        this.eventProcessor = eventProcessor;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class.getName());
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        this.poolTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ScriptDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ScriptDataSource source = new ScriptDataSource(context, this.poolTracker, this.executor, this.eventProcessor);
        source.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("datasource.id", configurationId);
        this.objectPool.addService(configurationId, (Object)source, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)source);
    }

    protected void disposeService(UserInformation userInformation, String id, ScriptDataSource service) {
        logger.info("Disposing: {}", (Object)id);
        this.objectPool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ScriptDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ScriptDataSource> entry, Map<String, String> parameters) throws Exception {
        ((ScriptDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

