/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.common.item.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.common.item.internal.HistoricalItemImpl;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFactoryImpl.class);
    private final Map<String, ItemWrapper> items = new HashMap<String, ItemWrapper>();
    private final BundleContext context;

    public ConfigurationFactoryImpl(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashSet<ItemWrapper> items;
        ConfigurationFactoryImpl configurationFactoryImpl = this;
        synchronized (configurationFactoryImpl) {
            items = new HashSet<ItemWrapper>(this.items.values());
            this.items.clear();
        }
        for (ItemWrapper item : items) {
            this.unregisterItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        ItemWrapper item;
        Map<String, ItemWrapper> map = this.items;
        synchronized (map) {
            item = this.items.remove(configurationId);
        }
        if (item != null) {
            this.unregisterItem(item);
        }
    }

    private void unregisterItem(ItemWrapper item) {
        item.getRegistration().unregister();
        item.getItem().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        logger.info("Update call for {} -> {}", new Object[]{configurationId, properties});
        ConfigurationFactoryImpl configurationFactoryImpl = this;
        synchronized (configurationFactoryImpl) {
            ItemWrapper item = this.items.get(configurationId);
            if (item == null) {
                logger.info("Creating new item: {}", (Object)configurationId);
                item = this.createItem(configurationId, properties);
            } else {
                logger.info("Updating {}", (Object)configurationId);
                item.update(properties);
            }
            this.items.put(configurationId, item);
        }
    }

    private ItemWrapper createItem(String configurationId, Map<String, String> properties) throws InvalidSyntaxException {
        String masterId = properties.get("datasource.id");
        if (masterId == null) {
            throw new IllegalArgumentException(String.format("'%s' is not set", "datasource.id"));
        }
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("service.pid", configurationId);
        ((Dictionary)serviceProperties).put("service.description", "A historical item implementation");
        ((Dictionary)serviceProperties).put("service.vendor", "Eclipse SCADA Project");
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("service.description", Variant.valueOf((Object)"A historical item implementation"));
        attributes.put("service.vendor", Variant.valueOf((Object)"openSCADA.org"));
        attributes.put("service.pid", Variant.valueOf((Object)configurationId));
        attributes.put("master.id", Variant.valueOf((Object)masterId));
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        for (Map.Entry entry : cfg.getPrefixed("information.").entrySet()) {
            attributes.put((String)entry.getKey(), VariantEditor.toVariant((String)((String)entry.getValue())));
        }
        HistoricalItemImpl item = new HistoricalItemImpl(configurationId, attributes, masterId, this.context);
        ServiceRegistration registration = this.context.registerService(HistoricalItem.class, (Object)item, serviceProperties);
        item.start();
        return new ItemWrapper(item, (ServiceRegistration<HistoricalItem>)registration);
    }

    protected final class ItemWrapper {
        private final HistoricalItemImpl item;
        private final ServiceRegistration<HistoricalItem> registration;

        public ItemWrapper(HistoricalItemImpl item, ServiceRegistration<HistoricalItem> registration) {
            this.item = item;
            this.registration = registration;
        }

        public HistoricalItemImpl getItem() {
            return this.item;
        }

        public ServiceRegistration<HistoricalItem> getRegistration() {
            return this.registration;
        }

        public void update(Map<String, String> properties) throws Exception {
            this.item.update(properties);
        }
    }
}

