/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.common.item.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.common.StorageHistoricalItem;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class HistoricalItemImpl
implements HistoricalItem,
DataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(HistoricalItemImpl.class);
    private static final int DEFAULT_MAX_BUFFER_SIZE = 1024;
    private final HistoricalItemInformation itemInformation;
    private String dataSourceId;
    private final SingleServiceTracker<StorageHistoricalItem> storageTracker;
    private StorageHistoricalItem service;
    private final Set<Query> openQueries = new HashSet<Query>();
    private final ObjectPoolTracker<DataSource> poolTracker;
    private SingleDataSourceTracker dataSourceTracker;
    private DataSource dataSource;
    private final Queue<DataItemValue> valueBuffer;
    private int maxBufferSize = 1024;

    public HistoricalItemImpl(HistoricalItemInformation itemInformation, String masterId, BundleContext context) throws InvalidSyntaxException {
        this.itemInformation = itemInformation;
        this.dataSourceId = masterId;
        this.valueBuffer = new LinkedList<DataItemValue>();
        this.storageTracker = new SingleServiceTracker(context, FilterUtil.createAndFilter((String)StorageHistoricalItem.class.getName(), (Map)new MapBuilder().put((Object)"service.pid", (Object)itemInformation.getItemId()).getMap()), (SingleServiceListener)new SingleServiceListener<StorageHistoricalItem>(){

            public void serviceChange(ServiceReference<StorageHistoricalItem> reference, StorageHistoricalItem service) {
                HistoricalItemImpl.this.setStorage(service);
            }
        });
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class);
    }

    protected synchronized void setDataSource(DataSource service) {
        logger.info("Set data source item: {}", (Object)service);
        if (this.dataSource != null) {
            this.dataSource.removeListener((DataSourceListener)this);
        }
        this.dataSource = service;
        if (this.dataSource != null) {
            this.dataSource.addListener((DataSourceListener)this);
        }
    }

    protected synchronized void setStorage(StorageHistoricalItem service) {
        logger.info("Setting storage: {}", (Object)service);
        if (this.service == service) {
            return;
        }
        this.closeOpenQueries();
        this.service = service;
        if (this.service != null) {
            logger.info(String.format("Pushing %s entries from value buffer", this.valueBuffer.size()));
            while (!this.valueBuffer.isEmpty()) {
                service.updateData(this.valueBuffer.poll());
            }
        }
    }

    public void start() throws InvalidSyntaxException {
        logger.info("Start HistoricalItem: {}", (Object)this.itemInformation.getItemId());
        this.storageTracker.open();
        this.poolTracker.open();
        this.updateDataSource();
    }

    public void stop() {
        logger.info("Stop HistoricalItem: {}", (Object)this.itemInformation.getItemId());
        this.storageTracker.close();
        if (this.dataSourceTracker != null) {
            this.dataSourceTracker.close();
            this.dataSourceTracker = null;
        }
        this.poolTracker.close();
    }

    public HistoricalItemImpl(String id, Map<String, Variant> attributes, String masterId, BundleContext context) throws InvalidSyntaxException {
        this(new HistoricalItemInformation(id, attributes), masterId, context);
    }

    public synchronized Query createQuery(QueryParameters parameters, QueryListener listener, boolean updateData) {
        Profiler p = new Profiler("hi.createQuery");
        p.setLogger(logger);
        if (this.service == null) {
            logger.warn("We have no service. We cannot create a query");
            return null;
        }
        p.start("call shi.createQuery");
        WrapperQuery query = new WrapperQuery(this.service.createQuery(parameters, listener, updateData));
        if (query.isValid()) {
            this.openQueries.add(query);
        } else {
            logger.warn("We have an invalid query");
        }
        p.stop().log();
        return query;
    }

    public HistoricalItemInformation getInformation() {
        return this.itemInformation;
    }

    private void closeOpenQueries() {
        for (Query query : this.openQueries) {
            query.close();
        }
        this.openQueries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DataItemValue value) {
        logger.debug("state changed: {}", (Object)value);
        HistoricalItemImpl historicalItemImpl = this;
        synchronized (historicalItemImpl) {
            if (this.service != null) {
                this.service.updateData(value);
            } else {
                logger.debug("State change ignored: {} missing storage", (Object)this.itemInformation.getItemId());
                int size = this.valueBuffer.size();
                if (size < this.maxBufferSize) {
                    logger.debug("State change recorded: buffer size: {}", (Object)size);
                    this.valueBuffer.add(value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, String> properties) throws InvalidSyntaxException {
        String dataSourceId = properties.get("datasource.id");
        HistoricalItemImpl historicalItemImpl = this;
        synchronized (historicalItemImpl) {
            logger.info("Updating...");
            try {
                this.maxBufferSize = Integer.parseInt(properties.get("maxBufferSize"));
            }
            catch (NumberFormatException numberFormatException) {
                this.maxBufferSize = 1024;
            }
            this.dataSourceId = dataSourceId;
            this.updateDataSource();
            logger.info("Updating... done");
        }
    }

    private void updateDataSource() throws InvalidSyntaxException {
        logger.debug("updateDataSource ()");
        if (this.dataSourceTracker != null) {
            this.dataSourceTracker.close();
            this.dataSourceTracker = null;
        }
        if (this.dataSourceId != null) {
            logger.debug("track datasource " + this.dataSourceId);
            this.dataSourceTracker = new SingleDataSourceTracker(this.poolTracker, this.dataSourceId, new SingleDataSourceTracker.ServiceListener(){

                public void dataSourceChanged(DataSource dataSource) {
                    HistoricalItemImpl.this.setDataSource(dataSource);
                }
            });
            this.dataSourceTracker.open();
        }
    }

    private class WrapperQuery
    implements Query {
        private final Query query;

        public WrapperQuery(Query query) {
            this.query = query;
        }

        public void changeParameters(QueryParameters parameters) {
            this.query.changeParameters(parameters);
        }

        public void close() {
            HistoricalItemImpl.this.openQueries.remove(this);
            this.query.close();
        }

        public boolean isValid() {
            return this.query != null;
        }
    }
}

