/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi;

import java.util.concurrent.Future;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.osgi.Messages;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.IteratingFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.TransformResultFuture;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHelper {
    public static final AuthorizationResult DEFAULT_RESULT = AuthorizationResult.createReject((StatusCode)StatusCodes.AUTHORIZATION_FAILED, (String)Messages.getString("AuthorizationHelper.DefaultMessage"));
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHelper.class);

    public static NotifyFuture<AuthorizationReply> authorize(Iterable<? extends AuthorizationRule> services, final AuthorizationContext context, final AuthorizationResult defaultResult) {
        logger.debug("Iterating authorize - {}", (Object)context.getRequest());
        IteratingAuthorizer future = new IteratingAuthorizer(services, defaultResult, context);
        future.startIterating();
        return new TransformResultFuture<AuthorizationResult, AuthorizationReply>((NotifyFuture)future){

            protected AuthorizationReply transform(AuthorizationResult from) throws Exception {
                logger.debug("Transforming result: {}", (Object)from);
                if (from == null) {
                    return AuthorizationReply.create((AuthorizationResult)defaultResult, (AuthorizationContext)context);
                }
                return AuthorizationReply.create((AuthorizationResult)from, (AuthorizationContext)context);
            }
        };
    }

    public static final class IteratingAuthorizer
    extends IteratingFuture<AuthorizationResult, AuthorizationRule> {
        private final AuthorizationResult defaultResult;
        private final AuthorizationContext context;

        public IteratingAuthorizer(Iterable<? extends AuthorizationRule> iterable, AuthorizationResult defaultResult, AuthorizationContext context) {
            super(iterable);
            this.defaultResult = defaultResult;
            this.context = context;
        }

        protected void handleComplete(Future<AuthorizationResult> future, AuthorizationRule current) throws Exception {
            AuthorizationResult reply = future.get();
            if (reply == null) {
                logger.debug("We got an abstain");
                this.processNext();
            } else {
                logger.debug("Somebody voted: {}", (Object)reply);
                this.setResult(reply);
            }
        }

        protected NotifyFuture<AuthorizationResult> perform(AuthorizationRule s) {
            logger.debug("Try next service: {}", (Object)s);
            return s.authorize(this.context);
        }

        protected NotifyFuture<AuthorizationResult> last() {
            return new InstantFuture((Object)this.defaultResult);
        }
    }
}

