/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.convert;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.base.extractor.convert.ValueConverter;
import org.eclipse.scada.core.Variant;

public class BooleanSetValueConverter
implements ValueConverter {
    private final Set<String> trueValues;
    private final Set<String> falseValues;
    private final Variant otherwise;
    private final boolean ignoreCase;

    public BooleanSetValueConverter(Set<String> trueValues, Set<String> falseValues, Boolean otherwise, boolean ignoreCase) {
        if (ignoreCase) {
            this.trueValues = BooleanSetValueConverter.uppercase(trueValues);
            this.falseValues = BooleanSetValueConverter.uppercase(falseValues);
        } else {
            this.trueValues = trueValues;
            this.falseValues = falseValues;
        }
        this.otherwise = Variant.valueOf((Object)otherwise);
        this.ignoreCase = ignoreCase;
    }

    private static Set<String> uppercase(Set<String> values) {
        HashSet<String> result = new HashSet<String>(values.size());
        for (String value : values) {
            result.add(value.toUpperCase());
        }
        return result;
    }

    @Override
    public Variant convert(String input) {
        String value;
        if (input == null) {
            return this.otherwise;
        }
        String string = value = this.ignoreCase ? input.toUpperCase() : input;
        if (this.trueValues.contains(value)) {
            return Variant.TRUE;
        }
        if (this.falseValues.contains(value)) {
            return Variant.FALSE;
        }
        return this.otherwise;
    }
}

