/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.pattern;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.base.extractor.convert.ValueConverter;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.extract.pattern.AbstractPatternExtractor;
import org.eclipse.scada.core.Variant;

public class VariableFieldPatternExtractor
extends AbstractPatternExtractor {
    private final Pattern fieldPattern;
    private final int fieldNameGroup;
    private final int valueGroup;
    private final ValueConverter converter;

    public VariableFieldPatternExtractor(Pattern fieldPattern, int fieldNameGroup, int valueGroup, ValueConverter converter) {
        this.fieldPattern = fieldPattern;
        this.fieldNameGroup = fieldNameGroup;
        this.valueGroup = valueGroup;
        this.converter = converter != null ? converter : ValueConverter.NULL;
    }

    @Override
    protected Map<ItemDescriptor, ItemValue> processData(String data) throws Exception {
        Matcher m = this.fieldPattern.matcher(data);
        HashMap<ItemDescriptor, ItemValue> result = new HashMap<ItemDescriptor, ItemValue>();
        while (m.find()) {
            String fieldName = m.group(this.fieldNameGroup);
            Variant value = this.converter.convert(m.group(this.valueGroup));
            result.put(new ItemDescriptor(fieldName, null), new ItemValue(value, null));
        }
        return result;
    }
}

