/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.split;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.base.extractor.extract.AbstractStringExtractor;
import org.eclipse.scada.base.extractor.extract.Extractor;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.input.Data;

public class SplitExtractor
extends AbstractStringExtractor {
    private final String splitPattern;
    private final Map<String, Extractor> subExtractors;
    private final Extractor subExtractor;

    public SplitExtractor(String splitPattern, Extractor subExtractor) {
        this.splitPattern = splitPattern;
        this.subExtractors = null;
        this.subExtractor = subExtractor;
    }

    public SplitExtractor(String splitPattern, Map<String, Extractor> subExtractors) {
        this.splitPattern = splitPattern;
        this.subExtractors = subExtractors;
        this.subExtractor = null;
    }

    @Override
    protected Map<ItemDescriptor, ItemValue> processData(String data) throws Exception {
        String[] toks = data.split(this.splitPattern);
        HashMap<ItemDescriptor, ItemValue> result = new HashMap<ItemDescriptor, ItemValue>();
        int i = 0;
        while (i < toks.length) {
            if (this.subExtractors != null) {
                this.extractMany(toks, result, i);
            } else if (this.subExtractor != null) {
                this.extractSingle(toks, result, i);
            }
            ++i;
        }
        return result;
    }

    private void extractSingle(String[] toks, Map<ItemDescriptor, ItemValue> result, int i) {
        this.extract(toks, result, i, null, this.subExtractor);
    }

    private void extractMany(String[] toks, Map<ItemDescriptor, ItemValue> result, int i) {
        for (Map.Entry<String, Extractor> entry : this.subExtractors.entrySet()) {
            this.extract(toks, result, i, entry.getKey(), entry.getValue());
        }
    }

    private void extract(String[] toks, Map<ItemDescriptor, ItemValue> result, int i, String prefix, Extractor value) {
        Extractor.Result localResult = value.processData(new Data(toks[i], null));
        if (localResult.getError() != null) {
            throw new RuntimeException(localResult.getError());
        }
        if (localResult.getItemValues() != null) {
            for (Map.Entry<ItemDescriptor, ItemValue> valueEntry : localResult.getItemValues().entrySet()) {
                ItemDescriptor globalDesc = this.makeGlobal("" + i, prefix, valueEntry.getKey());
                result.put(globalDesc, valueEntry.getValue());
            }
        }
    }

    private ItemDescriptor makeGlobal(String row, String prefix, ItemDescriptor descriptor) {
        String localId = prefix == null ? String.valueOf(row) + "." + descriptor.getLocalId() : String.valueOf(row) + "." + prefix + "." + descriptor.getLocalId();
        return new ItemDescriptor(localId, descriptor.getAttributes());
    }
}

