/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.table;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.base.extractor.convert.ValueConverter;
import org.eclipse.scada.base.extractor.extract.AbstractStringExtractor;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;

public class SplitTableExtractor
extends AbstractStringExtractor {
    private final String fieldSeparatorPattern;
    private final String lineSeparatorPattern;
    private final int idColumn;
    private final String[] header;
    private final ValueConverter converter;

    public SplitTableExtractor(String lineSeparatorPattern, String fieldSeparatorPattern, int idColumn) {
        this.lineSeparatorPattern = lineSeparatorPattern;
        this.fieldSeparatorPattern = fieldSeparatorPattern;
        this.idColumn = idColumn;
        this.header = null;
        this.converter = ValueConverter.NULL;
    }

    public SplitTableExtractor(String lineSeparatorPattern, String fieldSeparatorPattern, int idColumn, String[] header, ValueConverter converter) {
        this.lineSeparatorPattern = lineSeparatorPattern;
        this.fieldSeparatorPattern = fieldSeparatorPattern;
        this.idColumn = idColumn;
        this.header = header;
        this.converter = converter != null ? converter : ValueConverter.NULL;
    }

    @Override
    protected Map<ItemDescriptor, ItemValue> processData(String data) throws Exception {
        String[] header;
        int start;
        HashMap<ItemDescriptor, ItemValue> result = new HashMap<ItemDescriptor, ItemValue>();
        String[] lines = data.split(this.lineSeparatorPattern);
        if (this.header != null) {
            start = 0;
            header = this.header;
        } else {
            start = 1;
            header = this.splitFields(lines[0]);
        }
        int i = start;
        while (i < lines.length) {
            String[] fields = this.splitFields(lines[i]);
            String id = fields[this.idColumn];
            int j = 0;
            while (j < fields.length) {
                ItemDescriptor desc = new ItemDescriptor(String.valueOf(id) + "." + header[j], null);
                result.put(desc, new ItemValue(this.converter.convert(fields[j]), null));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private String[] splitFields(String string) {
        return string.split(this.fieldSeparatorPattern);
    }
}

