/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.input;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.base.extractor.input.AbstractInput;
import org.eclipse.scada.base.extractor.input.Data;

public abstract class AbstractScheduledInput
extends AbstractInput {
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> job;
    private final Runnable command = new Runnable(){

        @Override
        public void run() {
            AbstractScheduledInput.this.process();
        }
    };
    private boolean running;
    private final long period;

    protected static Object convert(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (charset == null) {
            return data;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(data));
        return cb.toString();
    }

    public AbstractScheduledInput(ScheduledExecutorService executor, long period) {
        super(executor);
        this.executor = executor;
        this.period = period;
    }

    @Override
    public synchronized void start() {
        if (this.job == null) {
            this.job = this.executor.scheduleAtFixedRate(this.command, 0L, this.period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.job != null) {
            this.job.cancel(false);
            while (this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.fireDisposed();
            this.job = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        block18: {
            try {
                try {
                    AbstractScheduledInput abstractScheduledInput = this;
                    synchronized (abstractScheduledInput) {
                        this.running = true;
                    }
                    Data data = this.makeData();
                    if (data != null) {
                        this.fireData(data);
                    }
                }
                catch (Exception e) {
                    this.fireData(new Data(null, e));
                    AbstractScheduledInput abstractScheduledInput = this;
                    synchronized (abstractScheduledInput) {
                        this.running = false;
                        this.notifyAll();
                        break block18;
                    }
                }
            }
            catch (Throwable throwable) {
                AbstractScheduledInput abstractScheduledInput = this;
                synchronized (abstractScheduledInput) {
                    this.running = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            AbstractScheduledInput abstractScheduledInput = this;
            synchronized (abstractScheduledInput) {
                this.running = false;
                this.notifyAll();
            }
        }
    }

    protected abstract Data makeData() throws Exception;
}

