/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.input.process;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.base.extractor.input.AbstractScheduledInput;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.input.process.CaptureOutputThread;
import org.eclipse.scada.base.extractor.input.process.ProcessData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInput
extends AbstractScheduledInput {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInput.class);
    private final ProcessBuilder processBuilder;
    private final Charset charset;

    public ProcessInput(ScheduledExecutorService executor, ProcessBuilder processBuilder, Charset charset, long period) {
        super(executor, period);
        this.charset = charset;
        this.processBuilder = processBuilder;
    }

    @Override
    protected Data makeData() throws Exception {
        logger.debug("Starting process: {}", (Object)this.processBuilder);
        Process p = this.processBuilder.start();
        try {
            this.close(p.getOutputStream());
            CaptureOutputThread inputReader = new CaptureOutputThread(p.getInputStream());
            CaptureOutputThread errorReader = new CaptureOutputThread(p.getErrorStream());
            logger.trace("Starting readers");
            inputReader.start();
            errorReader.start();
            logger.debug("Begin waitFor");
            int rc = p.waitFor();
            logger.debug("Process returned - rc = {}", (Object)rc);
            inputReader.join();
            errorReader.join();
            logger.debug("Threads returned as well");
            IOException error = null;
            if (errorReader.getError() != null) {
                error = errorReader.getError();
            }
            if (inputReader.getError() != null) {
                error = inputReader.getError();
            }
            logger.trace("Return data");
            ProcessData processData = new ProcessData(ProcessInput.convert(inputReader.getData(), this.charset), ProcessInput.convert(errorReader.getData(), this.charset), rc, error);
            return processData;
        }
        catch (Exception e) {
            Data data = new Data(null, e);
            return data;
        }
        finally {
            this.close(p.getInputStream());
            this.close(p.getErrorStream());
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close", (Throwable)e);
            }
        }
    }
}

