/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.input.url;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.base.extractor.input.AbstractScheduledInput;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.input.url.UrlConnectionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionInput
extends AbstractScheduledInput {
    private static final Logger logger = LoggerFactory.getLogger(UrlConnectionInput.class);
    private final URL url;
    private final boolean probeCharset;
    private final Charset charset;
    private static Pattern typePattern = Pattern.compile(".*charset=([a-zA-Z-0-9]+?)");

    public UrlConnectionInput(ScheduledExecutorService executor, URL url, boolean probeCharset, long period) {
        super(executor, period);
        this.url = url;
        this.probeCharset = probeCharset;
        this.charset = null;
    }

    public UrlConnectionInput(ScheduledExecutorService executor, URL url, Charset charset, long period) {
        super(executor, period);
        this.url = url;
        this.probeCharset = false;
        this.charset = charset;
    }

    @Override
    protected Data makeData() throws Exception {
        URLConnection connection = this.url.openConnection();
        connection.connect();
        int len = connection.getContentLength();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(len > 0 ? len : 0);
        byte[] buffer = new byte[4096];
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = connection.getInputStream();){
            int rc;
            while ((rc = stream.read(buffer)) > 0) {
                bos.write(buffer, 0, rc);
            }
            bos.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String encoding = connection.getContentEncoding();
        String type = connection.getContentType();
        logger.debug("Content-Encoding: {}", (Object)encoding);
        logger.debug("Content-Type: {}", (Object)type);
        Charset charset = null;
        if (this.charset != null) {
            charset = this.charset;
        } else if (this.probeCharset) {
            charset = this.makeCharsetFromType(type);
        }
        return new UrlConnectionData(UrlConnectionInput.convert(buffer, charset), null);
    }

    private Charset makeCharsetFromType(String type) {
        Matcher m = typePattern.matcher(type);
        if (!m.matches()) {
            return null;
        }
        String charset = m.group(1);
        try {
            return Charset.forName(charset);
        }
        catch (Exception e) {
            logger.warn("Failed to find charset", (Throwable)e);
            return null;
        }
    }
}

