/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.average;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.average.AverageDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class AverageDataSourceFactory
extends AbstractServiceConfigurationFactory<AverageDataSource> {
    private final ExecutorService executor;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<AverageDataSource> avgObjectPool;
    private final ObjectPoolImpl<DataSource> dsObjectPool;
    private final ServiceRegistration<?> avgPoolRegistration;
    private final ServiceRegistration<?> dsPoolRegistration;

    public AverageDataSourceFactory(BundleContext context, ExecutorService executor) throws InvalidSyntaxException {
        super(context);
        this.executor = executor;
        this.avgObjectPool = new ObjectPoolImpl();
        this.avgPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.avgObjectPool, AverageDataSource.class);
        this.dsObjectPool = new ObjectPoolImpl();
        this.dsPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.dsObjectPool, DataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class.getName());
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.dsPoolRegistration.unregister();
        this.avgPoolRegistration.unregister();
        this.dsObjectPool.dispose();
        this.avgObjectPool.dispose();
        this.poolTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<AverageDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        AverageDataSource dataSource = new AverageDataSource(configurationId, this.poolTracker, this.executor, this.dsObjectPool);
        dataSource.update(parameters);
        this.avgObjectPool.addService(configurationId, (Object)dataSource, null);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)dataSource);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, AverageDataSource service) {
        this.avgObjectPool.removeService(configurationId, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<AverageDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<AverageDataSource> entry, Map<String, String> parameters) throws Exception {
        ((AverageDataSource)entry.getService()).update(parameters);
        return null;
    }
}

