/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.ConfigurationException;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.exporter.NetExport;
import org.eclipse.scada.da.server.exporter.NgpExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveExport {
    private static final Logger logger = LoggerFactory.getLogger(HiveExport.class);
    private final Hive hive;
    private final Collection<Export> exports = new CopyOnWriteArrayList<Export>();

    public HiveExport(Hive hive) {
        this.hive = hive;
    }

    public synchronized void start() throws Exception {
        logger.info("Starting hive: {}", (Object)this.hive);
        this.hive.start();
        for (Export export : this.exports) {
            try {
                export.start();
            }
            catch (Exception e) {
                logger.error("Failed to start export", (Throwable)e);
            }
        }
    }

    public synchronized void stop() throws Exception {
        logger.info("Stopping hive: {}", (Object)this.hive);
        for (Export export : this.exports) {
            try {
                export.stop();
            }
            catch (Exception e) {
                logger.error("Failed to stop export", (Throwable)e);
            }
        }
        this.hive.stop();
    }

    public Export addExport(String endpointUri) throws ConfigurationException {
        logger.info("Adding export: {}", (Object)endpointUri);
        ConnectionInformation ci = ConnectionInformation.fromURI((String)endpointUri);
        Export export = this.findExport(ci);
        if (export == null) {
            logger.info("No exporter found for endpoint: {}", (Object)endpointUri);
            throw new ConfigurationException(String.format("No exporter found for endpoint: %s", endpointUri));
        }
        this.exports.add(export);
        return export;
    }

    protected Export findExport(ConnectionInformation ci) throws ConfigurationException {
        logger.info("Requested export to: {}", (Object)ci);
        if (!ci.getInterface().equalsIgnoreCase("da")) {
            throw new ConfigurationException(String.format("Interface must be 'da' but is '%s'", ci.getInterface()));
        }
        try {
            if (ci.getDriver().equalsIgnoreCase("net") || ci.getDriver().equalsIgnoreCase("gmpp")) {
                logger.debug("Create new 'net' exporter");
                return new NetExport(this.hive, ci);
            }
            if (ci.getDriver().equalsIgnoreCase("ngp")) {
                logger.debug("Create new 'ngp' exporter");
                return new NgpExport(this.hive, ci);
            }
            throw new ConfigurationException(String.format("Driver '%s' is unknown", ci.getDriver()));
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to configure exporter", e);
        }
    }

    public Collection<Export> getExports() {
        return Collections.unmodifiableCollection(this.exports);
    }
}

