/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ds.DataStore;
import org.eclipse.scada.ds.storage.jdbc.internal.BufferingStorageDao;
import org.eclipse.scada.ds.storage.jdbc.internal.CachingStorageDao;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDaoBase64Impl;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDaoBlobImpl;
import org.eclipse.scada.ds.storage.jdbc.internal.StorageImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String DS_PREFIX = "org.eclipse.scada.ds.storage.jdbc";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private DataSourceFactoryTracker dataSourceFactoryTracker;
    private ServiceRegistration<DataStore> serviceHandle;
    private StorageImpl storageImpl;
    private ScheduledExecutorService scheduler;

    private static Type getType() {
        String type = System.getProperty("org.eclipse.scada.ds.storage.jdbc.encoder", "blob");
        try {
            return Type.valueOf(type.toUpperCase());
        }
        catch (Exception exception) {
            return Type.BLOB;
        }
    }

    public void start(final BundleContext context) throws Exception {
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        String driver = DataSourceHelper.getDriver((String)DS_PREFIX, (String)"org.eclipse.scada.jdbc");
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        this.dataSourceFactoryTracker = new DataSourceFactoryTracker(context, driver, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
                Activator.this.unregister();
                if (service != null) {
                    Activator.this.register(service, context);
                }
            }
        });
        this.dataSourceFactoryTracker.open(true);
    }

    protected void register(DataSourceFactory service, BundleContext context) {
        JdbcStorageDao storage = null;
        try {
            switch (Activator.getType()) {
                case BLOB: {
                    logger.info("Registering BLOB implemenation");
                    storage = this.configure(new JdbcStorageDaoBlobImpl(service, Activator.getDataSourceProperties(), Activator.isConnectionPool()));
                    break;
                }
                case BASE64: {
                    logger.info("Registering BASE64 implemenation");
                    storage = this.configure(new JdbcStorageDaoBase64Impl(service, Activator.getDataSourceProperties(), Activator.isConnectionPool()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to create service", (Throwable)e);
        }
        if (storage != null) {
            this.storageImpl = new StorageImpl(storage);
            Hashtable<String, String> properties = new Hashtable<String, String>(1);
            ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
            this.serviceHandle = context.registerService(DataStore.class, (Object)this.storageImpl, properties);
        }
    }

    private JdbcStorageDao configure(JdbcStorageDao storageImpl) {
        JdbcStorageDao result = storageImpl;
        if (!Boolean.getBoolean("org.eclipse.scada.ds.storage.jdbc.disableBuffer")) {
            logger.info("Adding write buffer");
            result = new BufferingStorageDao(result);
        }
        if (!Boolean.getBoolean("org.eclipse.scada.ds.storage.jdbc.disableCache")) {
            logger.info("Adding cache");
            result = new CachingStorageDao(result, this.scheduler, Long.getLong("org.eclipse.scada.ds.storage.jdbc.cleanUpCacheDelay", 600L));
        }
        return result;
    }

    private static Properties getDataSourceProperties() {
        return DataSourceHelper.getDataSourceProperties((String)DS_PREFIX, (String)"org.eclipse.scada.jdbc");
    }

    private static boolean isConnectionPool() {
        return DataSourceHelper.isConnectionPool((String)DS_PREFIX, (String)"org.eclipse.scada.jdbc", (boolean)false);
    }

    protected void unregister() {
        if (this.serviceHandle != null) {
            this.serviceHandle.unregister();
            this.serviceHandle = null;
        }
        if (this.storageImpl != null) {
            this.storageImpl.dispose();
            this.storageImpl = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.unregister();
        this.dataSourceFactoryTracker.close();
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    private static enum Type {
        BASE64,
        BLOB;

    }
}

