/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingStorageDao
implements JdbcStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(CachingStorageDao.class);
    private final JdbcStorageDao targetDao;
    private final Map<String, DataNode> cacheMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final ScheduledFuture<?> clearCacheFuture;

    public CachingStorageDao(JdbcStorageDao targetDao, ScheduledExecutorService scheduler, long cleanUpCacheDelay) {
        if (targetDao == null) {
            throw new IllegalArgumentException("'targetDao' must not be null");
        }
        if (scheduler == null) {
            throw new IllegalArgumentException("'scheduler' must not be null");
        }
        this.targetDao = targetDao;
        try {
            this.writeLock.lock();
            logger.info("Starting cache prefill");
            Collection<DataNode> nodes = targetDao.readAllNodes();
            this.cacheMap = new HashMap<String, DataNode>(nodes.size());
            logger.debug("Prefill found {} entries", (Object)nodes.size());
            for (DataNode node : nodes) {
                this.cacheMap.put(node.getId(), node);
            }
            logger.info("Prefill complete");
            this.clearCacheFuture = scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    CachingStorageDao.this.clearCache();
                }
            }, cleanUpCacheDelay, TimeUnit.SECONDS);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Collection<DataNode> readAllNodes() {
        try {
            this.readLock.lock();
            ArrayList<DataNode> arrayList = new ArrayList<DataNode>(this.cacheMap.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public DataNode readNode(String nodeId) {
        try {
            this.readLock.lock();
            if (this.cacheMap.containsKey(nodeId)) {
                DataNode dataNode = this.cacheMap.get(nodeId);
                return dataNode;
            }
        }
        finally {
            this.readLock.unlock();
        }
        DataNode dataNode = this.targetDao.readNode(nodeId);
        try {
            this.writeLock.lock();
            if (this.cacheMap.containsKey(nodeId)) {
                DataNode dataNode2 = this.cacheMap.get(nodeId);
                return dataNode2;
            }
            this.cacheMap.put(nodeId, dataNode);
            DataNode dataNode3 = dataNode;
            return dataNode3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void writeNode(DataNode node) {
        try {
            this.writeLock.lock();
            this.cacheMap.put(node.getId(), node);
        }
        finally {
            this.writeLock.unlock();
        }
        this.targetDao.writeNode(node);
    }

    @Override
    public void deleteNode(String nodeId) {
        try {
            this.writeLock.lock();
            this.cacheMap.remove(nodeId);
        }
        finally {
            this.writeLock.unlock();
        }
        this.targetDao.deleteNode(nodeId);
    }

    private void clearCache() {
        logger.info("clearing cache");
        try {
            this.writeLock.lock();
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void dispose() {
        if (this.clearCacheFuture != null) {
            this.clearCacheFuture.cancel(false);
        }
        this.clearCache();
        this.targetDao.dispose();
    }
}

