/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.AbstractStorage;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl
extends AbstractStorage {
    private static final Logger logger = LoggerFactory.getLogger(StorageImpl.class);
    private final JdbcStorageDao storage;
    private final ExecutorService executorService = new ExportedExecutorService(StorageImpl.class.getName(), 1, 1, 0L, TimeUnit.MILLISECONDS);

    public StorageImpl(JdbcStorageDao storage) {
        this.storage = storage;
    }

    protected Executor getExecutor() {
        return this.executorService;
    }

    public synchronized void dispose() {
        super.dispose();
        this.executorService.shutdown();
        this.storage.dispose();
    }

    public synchronized NotifyFuture<DataNode> readNode(final String nodeId) {
        try {
            FutureTask task = new FutureTask((Callable)new Callable<DataNode>(){

                @Override
                public DataNode call() throws Exception {
                    return StorageImpl.this.storage.readNode(nodeId);
                }
            });
            this.executorService.execute((Runnable)task);
            return task;
        }
        catch (Exception e) {
            logger.warn("Failed to load data node", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
    }

    public synchronized NotifyFuture<Void> writeNode(final DataNode node) {
        try {
            FutureTask task = new FutureTask((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        StorageImpl.this.storage.writeNode(node);
                        StorageImpl.this.fireUpdate(node);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to write node", (Throwable)e);
                        throw new RuntimeException("Failed to write node", e);
                    }
                    return null;
                }
            });
            this.executorService.execute((Runnable)task);
            return task;
        }
        catch (Exception e) {
            logger.warn("Failed to write data node", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
    }

    public synchronized NotifyFuture<Void> deleteNode(final String nodeId) {
        try {
            FutureTask task = new FutureTask((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    StorageImpl.this.storage.deleteNode(nodeId);
                    return null;
                }
            });
            this.executorService.execute((Runnable)task);
            return task;
        }
        catch (Exception e) {
            logger.warn("Failed to write data node", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
    }
}

