/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.dave;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.scada.protocol.dave.DaveMessage;
import org.eclipse.scada.utils.lang.Immutable;

public class DaveReadRequest
extends DaveMessage {
    private final Collection<Request> requests = new LinkedList<Request>();

    public void addRequest(Request request) {
        this.requests.add(request);
    }

    public Collection<Request> getRequests() {
        return Collections.unmodifiableCollection(this.requests);
    }

    @Immutable
    public static class Request {
        private final byte area;
        private final short block;
        private final short count;
        private final short start;
        private final AddressType type;

        public Request(byte area, short block, short start, short count) {
            this(AddressType.BYTE, area, block, start, count);
        }

        public Request(AddressType type, byte area, short block, short start, short count) {
            this.type = type;
            this.area = area;
            this.block = block;
            this.start = start;
            this.count = count;
        }

        public AddressType getType() {
            return this.type;
        }

        public short getStart() {
            return this.start;
        }

        public byte getArea() {
            return this.area;
        }

        public short getBlock() {
            return this.block;
        }

        public short getCount() {
            return this.count;
        }

        public String toString() {
            return String.format("Area: %s, block: %s, start: %s, count: %s", this.area, this.block, this.start, this.count);
        }

        public static enum AddressType {
            BIT(1),
            BYTE(2),
            WORD(4);

            private byte type;

            private AddressType(byte type) {
                this.type = type;
            }

            public byte getType() {
                return this.type;
            }
        }
    }
}

