/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.authz.signature.RequestValidator;
import org.eclipse.scada.sec.authz.signature.SignatureRequestBuilder;
import org.eclipse.scada.sec.authz.signature.StatusCodes;
import org.eclipse.scada.sec.authz.signature.X509KeySelector;
import org.eclipse.scada.sec.authz.signature.X509KeySelectorResult;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.XMLSignatureCallback;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.TransformResultFuture;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class RequestSignatureRuleImpl
implements AuthorizationRule {
    private static final Logger logger = LoggerFactory.getLogger(RequestSignatureRuleImpl.class);
    private final SignatureRequestBuilder builder;
    private final RequestValidator validator;
    private final AuditLogService auditLogService;
    private final boolean indent;
    private final ScriptExecutor postProcessor;
    private final AuthenticationImplementation authenticator;
    private ScheduledFuture<?> job;
    private final X509KeySelector keySelector;

    public RequestSignatureRuleImpl(ScheduledExecutorService executor, SignatureRequestBuilder builder, RequestValidator validator, X509KeySelector keySelector, AuditLogService auditLogService, boolean indent, ScriptExecutor postProcessor, AuthenticationImplementation authenticator, int reloadPeriod) {
        this.builder = builder;
        this.validator = validator;
        this.auditLogService = auditLogService;
        this.indent = indent;
        this.postProcessor = postProcessor;
        this.authenticator = authenticator;
        this.keySelector = keySelector;
        if (reloadPeriod > 0) {
            logger.debug("Starting reload job: {} ms", (Object)reloadPeriod);
            this.job = executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    RequestSignatureRuleImpl.this.reload();
                }
            }, 0L, reloadPeriod, TimeUnit.MILLISECONDS);
        } else {
            logger.debug("Reloading once");
            this.reload();
        }
    }

    protected void reload() {
        logger.debug("Reloading");
        this.keySelector.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ScheduledFuture<?> job;
        RequestSignatureRuleImpl requestSignatureRuleImpl = this;
        synchronized (requestSignatureRuleImpl) {
            job = this.job;
            this.job = null;
        }
        if (job != null) {
            logger.debug("Cancelling reload job");
            job.cancel(true);
        }
    }

    public NotifyFuture<AuthorizationResult> authorize(final AuthorizationContext context) {
        NotifyFuture future;
        final Document doc = this.builder.buildFromRequest(context.getRequest());
        try {
            future = Callbacks.callback((CallbackHandler)context.getCallbackHandler(), (Callback)new XMLSignatureCallback(this.builder.toString(doc, this.indent)));
        }
        catch (Exception e) {
            return new InstantErrorFuture((Throwable)e);
        }
        return new TransformResultFuture<Callback[], AuthorizationResult>(future){

            protected AuthorizationResult transform(Callback[] from) throws Exception {
                return RequestSignatureRuleImpl.this.validateCallback(context, doc, (XMLSignatureCallback)from[0]);
            }
        };
    }

    protected AuthorizationResult validateCallback(AuthorizationContext context, Document doc, XMLSignatureCallback callback) {
        if (callback.isCanceled() || callback.getSignedDocument() == null) {
            return AuthorizationResult.createReject((StatusCode)StatusCodes.VERIFY_NO_SIGNATURE, (String)"No signature data found");
        }
        try {
            Document signedDoc = this.builder.fromString(callback.getSignedDocument());
            RequestValidator.Result result = this.validator.validate(signedDoc);
            String signatureString = this.builder.toString(signedDoc, true);
            if (!result.isValid()) {
                context.getContext().put("failedSignature", signatureString);
                this.auditLogService.info("Validation failed:\n{}", new Object[]{signatureString});
                return AuthorizationResult.createReject((StatusCode)StatusCodes.VERIFY_SIGNATURE_INVALID, (String)"Signature is not valid");
            }
            try {
                this.builder.compare(doc, signedDoc);
            }
            catch (Exception e) {
                context.getContext().put("failedSignature", signatureString);
                this.auditLogService.info("Requests don't match\n\tOriginal: {}\n\tSigned: {}", new Object[]{this.builder.toString(doc, true), this.builder.toString(signedDoc, true)});
                return AuthorizationResult.createReject((Throwable)e);
            }
            context.getContext().put("xmlsig.signatureString", signatureString);
            context.getContext().put("xmlsig.signature", result.getSignature());
            context.getContext().put("xmlsig.keySelectorResult", result.getKeySelectorResult());
            if (result.getKeySelectorResult() instanceof X509KeySelectorResult) {
                context.getContext().put("xmlsig.x509Certificate", ((X509KeySelectorResult)result.getKeySelectorResult()).getCertificate());
            }
            this.postProcess(context, result);
            return null;
        }
        catch (Exception e) {
            this.auditLogService.info("Failed to validate", (Throwable)e, new Object[0]);
            return AuthorizationResult.createReject((Throwable)e);
        }
    }

    private void postProcess(AuthorizationContext context, RequestValidator.Result result) throws Exception {
        if (this.postProcessor == null) {
            return;
        }
        logger.debug("Running post processor");
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        HashMap<String, Object> scriptObjects = new HashMap<String, Object>();
        scriptObjects.put("authorizationContext", context);
        scriptObjects.put("authenticator", this.authenticator);
        this.postProcessor.execute((ScriptContext)scriptContext, scriptObjects);
    }
}

