/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.eclipse.scada.sec.authz.signature.StatusCodes;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class RequestValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    private final XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
    private final KeySelector keySelector;

    public RequestValidator(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    public Result validate(Document doc) throws Exception {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            return new Result(StatusCodes.VALIDATE_NO_SIGNATURE_DATA, "No signature data found");
        }
        DOMValidateContext dvc = new DOMValidateContext(this.keySelector, nl.item(0));
        XMLSignature signature = this.factory.unmarshalXMLSignature(dvc);
        try {
            boolean result = signature.validate(dvc);
            return new Result(result, signature);
        }
        catch (XMLSignatureException e) {
            logger.debug("Failed to perform validation", (Throwable)e);
            return Result.INVALID;
        }
    }

    public static class Result {
        public static Result INVALID = new Result(false);
        private final boolean valid;
        private final KeySelectorResult keySelectorResult;
        private final StatusCode statusCode;
        private final String message;
        private final XMLSignature signature;

        public Result(boolean valid) {
            this.valid = valid;
            this.signature = null;
            this.keySelectorResult = null;
            this.statusCode = null;
            this.message = null;
        }

        public Result(boolean valid, XMLSignature signature) {
            this.valid = valid;
            this.signature = signature;
            this.keySelectorResult = signature.getKeySelectorResult();
            this.statusCode = null;
            this.message = null;
        }

        public Result(StatusCode statusCode, String message) {
            this.valid = false;
            this.signature = null;
            this.keySelectorResult = null;
            this.statusCode = statusCode;
            this.message = message;
        }

        public XMLSignature getSignature() {
            return this.signature;
        }

        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public KeySelectorResult getKeySelectorResult() {
            return this.keySelectorResult;
        }
    }
}

