/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationService;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.authz.signature.RequestSignatureRuleImpl;
import org.eclipse.scada.sec.authz.signature.RequestValidator;
import org.eclipse.scada.sec.authz.signature.SignatureRequestBuilder;
import org.eclipse.scada.sec.authz.signature.X509CA;
import org.eclipse.scada.sec.authz.signature.X509KeySelector;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.script.Scripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureAuthorizationService
implements AuthorizationService {
    private static final Logger logger = LoggerFactory.getLogger(SignatureAuthorizationService.class);
    private AuditLogService auditLogService;
    private AuthenticationImplementation authenticationImplementation;
    private final CertificateFactory cf = CertificateFactory.getInstance("X.509");
    private ScheduledExportedExecutorService executor;

    public void setAuthenticationImplementation(AuthenticationImplementation authenticationImplementation) {
        this.authenticationImplementation = authenticationImplementation;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    public void activate() {
        this.executor = new ScheduledExportedExecutorService("org.eclipse.scada.sec.authz.signature", 1);
    }

    public void deactivate() {
        this.executor.shutdown();
        this.executor = null;
    }

    public synchronized AuthorizationRule createRule(Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        boolean indent = cfg.getBoolean("indent", false);
        String script = cfg.getString("postProcessor", null);
        String engine = cfg.getString("postProcessor.engine", "JavaScript");
        ScriptExecutor postProcessor = script != null ? new ScriptExecutor(Scripts.createManager((ClassLoader)SignatureAuthorizationService.class.getClassLoader()), engine, script, SignatureAuthorizationService.class.getClassLoader()) : null;
        int reloadPeriod = cfg.getInteger("reloadPeriod", 0);
        X509KeySelector keySelector = this.makeKeySelector(properties);
        return new RequestSignatureRuleImpl((ScheduledExecutorService)this.executor, new SignatureRequestBuilder(), new RequestValidator(keySelector), keySelector, this.auditLogService, indent, postProcessor, this.authenticationImplementation, reloadPeriod);
    }

    private X509KeySelector makeKeySelector(Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        LinkedList<X509CA> cas = new LinkedList<X509CA>();
        Map caProperties = cfg.getPrefixed("ca.");
        for (Map.Entry entry : caProperties.entrySet()) {
            LinkedList<String> crls;
            String caCertUrl;
            String key = (String)entry.getKey();
            if (key.equals("cert")) {
                caCertUrl = (String)entry.getValue();
                crls = new LinkedList<String>();
                crls.addAll(new ConfigurationDataHelper(caProperties).getPrefixed("crl.").values());
                String crlUrl = (String)caProperties.get("crl");
                if (crlUrl != null) {
                    crls.add(crlUrl);
                }
                logger.debug("CRL uris - {}", crls);
                cas.add(new X509CA(this.cf, caCertUrl, crls));
                continue;
            }
            if (!key.endsWith(".cert")) continue;
            caCertUrl = (String)entry.getValue();
            crls = new LinkedList();
            String prefix = String.valueOf(key.substring(0, key.length() - ".cert".length())) + ".crl";
            logger.debug("Using CRL prefix - {}", (Object)prefix);
            crls.addAll(new ConfigurationDataHelper(caProperties).getPrefixed(String.valueOf(prefix) + ".").values());
            String crlUrl = (String)caProperties.get(prefix);
            if (crlUrl != null) {
                crls.add(crlUrl);
            }
            logger.debug("CRL uris - {}", crls);
            cas.add(new X509CA(this.cf, caCertUrl, crls));
        }
        if (cas.isEmpty()) {
            throw new IllegalStateException("No key selector configuration found");
        }
        return new X509KeySelector(cas);
    }
}

