/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.io.StringReader;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.UserInformation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SignatureRequestBuilder {
    public static final String NAMESPACE = System.getProperty("org.eclipse.scada.sec.authz.signature.xmlNamespace", "urn:eclipse:scada:sec:request");
    private final DocumentBuilderFactory dbf;
    private final DocumentBuilder db;
    private TransformerFactory tf;
    private final boolean injectRandomId;
    private final SecureRandom random = new SecureRandom();

    public SignatureRequestBuilder() throws Exception {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureRequestBuilder(boolean injectRandomId) throws Exception {
        this.injectRandomId = injectRandomId;
        SignatureRequestBuilder signatureRequestBuilder = this;
        synchronized (signatureRequestBuilder) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
            this.dbf.setCoalescing(true);
            this.dbf.setIgnoringComments(true);
            this.db = this.dbf.newDocumentBuilder();
            this.tf = TransformerFactory.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document fromString(String str) throws Exception {
        SignatureRequestBuilder signatureRequestBuilder = this;
        synchronized (signatureRequestBuilder) {
            return this.db.parse(new InputSource(new StringReader(str)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildFromRequest(AuthorizationRequest request) {
        Document doc;
        SignatureRequestBuilder signatureRequestBuilder = this;
        synchronized (signatureRequestBuilder) {
            doc = this.db.newDocument();
        }
        this.fillDocument(doc, request);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Document doc, boolean indent) throws Exception {
        Transformer t;
        SignatureRequestBuilder signatureRequestBuilder = this;
        synchronized (signatureRequestBuilder) {
            t = this.tf.newTransformer();
        }
        if (indent) {
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            t.setOutputProperty("indent", "yes");
        }
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(doc), new StreamResult(sw));
        return sw.toString();
    }

    private void fillDocument(Document doc, AuthorizationRequest request) {
        Element root = doc.createElementNS(NAMESPACE, "request:request");
        doc.appendChild(root);
        root.setAttribute("xmlns:request", NAMESPACE);
        if (this.injectRandomId) {
            root.setAttributeNS(NAMESPACE, "request:id", String.format("%016x", this.random.nextLong()));
        }
        if (request.getObjectType() != null) {
            root.setAttributeNS(NAMESPACE, "request:objectType", request.getObjectType());
        }
        if (request.getObjectId() != null) {
            root.setAttributeNS(NAMESPACE, "request:objectId", request.getObjectId());
        }
        if (request.getAction() != null) {
            root.setAttributeNS(NAMESPACE, "request:action", request.getAction());
        }
        if (request.getUserInformation() != null && !request.getUserInformation().isAnonymous()) {
            root.appendChild(this.makeUserElement(doc, request.getUserInformation()));
        }
        if (request.getContext() != null && !request.getContext().isEmpty()) {
            root.appendChild(this.makeContextElement(doc, request.getContext()));
        }
    }

    private Node makeContextElement(Document doc, Map<String, Object> context) {
        return this.makeMapElement(doc, context, NAMESPACE, "request:context");
    }

    private Element makeMapElement(Document doc, Map<?, ?> map, String namespace, String elementName) {
        Element ele = doc.createElementNS(namespace, elementName);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Element ee = doc.createElementNS(NAMESPACE, "request:entry");
            ee.setAttributeNS(NAMESPACE, "request:key", "" + entry.getKey());
            ele.appendChild(ee);
            Object value = entry.getValue();
            if (value instanceof Map) {
                ee.appendChild(this.makeMapElement(doc, (Map)value, namespace, "request:map"));
                continue;
            }
            if (value == null) continue;
            ee.appendChild(doc.createTextNode("" + value));
        }
        return ele;
    }

    private Node makeUserElement(Document doc, UserInformation userInformation) {
        Element user = doc.createElementNS(NAMESPACE, "request:user");
        user.setAttributeNS(NAMESPACE, "request:name", userInformation.getName());
        return user;
    }

    public boolean isEqual(Document sourceDoc, Document signedDoc) {
        try {
            this.compare(sourceDoc, signedDoc);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void compare(Document sourceDoc, Document signedDoc) throws Exception {
        Document d1 = this.cloneDoc(sourceDoc);
        Document d2 = this.cloneDoc(signedDoc);
        NodeList nl = d2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        while (nl.getLength() > 0) {
            Node item = nl.item(0);
            item.getParentNode().removeChild(item);
        }
        d1.normalizeDocument();
        d2.normalizeDocument();
        Element root1 = d1.getDocumentElement();
        Element root2 = d2.getDocumentElement();
        this.compareNode(root1, root2);
    }

    public Document cloneDoc(Document doc) throws TransformerException {
        Transformer tx = this.tf.newTransformer();
        DOMSource source = new DOMSource(doc);
        DOMResult result = new DOMResult();
        tx.transform(source, result);
        return (Document)result.getNode();
    }

    private void compareNode(Node n1, Node n2) {
        if (!this.compareString(n1.getNamespaceURI(), n2.getNamespaceURI())) {
            throw new IllegalStateException(String.format("Nodes differ by namespace - %s <-> %s", n1.getNamespaceURI(), n2.getNamespaceURI()));
        }
        if (!this.compareString(n1.getLocalName(), n2.getLocalName())) {
            throw new IllegalStateException("Nodes differ by local name");
        }
        if (!this.compareString(n1.getTextContent(), n2.getTextContent())) {
            throw new IllegalStateException("Nodes differ by text content");
        }
        this.compareLists(n1.getAttributes(), n2.getAttributes());
        this.compareLists(n1.getChildNodes(), n2.getChildNodes());
    }

    private void compareLists(NamedNodeMap nl1, NamedNodeMap nl2) {
        if (nl1 == nl2) {
            return;
        }
        if (nl1.getLength() != nl2.getLength()) {
            throw new IllegalStateException("Different number of child nodes");
        }
        int i = 0;
        while (i < nl1.getLength()) {
            this.compareNode(nl1.item(i), nl2.item(i));
            ++i;
        }
    }

    private void compareLists(NodeList nl1, NodeList nl2) {
        if (nl1.getLength() != nl2.getLength()) {
            throw new IllegalStateException("Different number of child nodes");
        }
        int i = 0;
        while (i < nl1.getLength()) {
            this.compareNode(nl1.item(i), nl2.item(i));
            ++i;
        }
    }

    private boolean compareString(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

